-- SQL script to add employee number settings
-- Run this in your database if you cannot run migrations due to PHP version

-- Insert employee number generation settings
INSERT INTO `system_settings` (`key`, `value`, `type`, `description`, `is_public`, `created_at`, `updated_at`) VALUES
('enable_auto_employee_number', '1', 'boolean', 'Automatically generate employee numbers when creating new employees', 0, NOW(), NOW()),
('employee_number_prefix', 'EMP', 'string', 'Prefix for auto-generated employee numbers (e.g., EMP0001, STAFF0001)', 0, NOW(), NOW()),
('employee_number_start', '1', 'number', 'Starting number for auto-generated employee numbers', 0, NOW(), NOW()),
('employee_number_padding', '4', 'number', 'Number of digits for employee number (e.g., 4 = 0001, 5 = 00001)', 0, NOW(), NOW());

-- Note: If the records already exist, delete them first:
-- DELETE FROM `system_settings` WHERE `key` IN ('enable_auto_employee_number', 'employee_number_prefix', 'employee_number_start', 'employee_number_padding');
