# Real-Time Sign-In System - Client Presentation Flowchart

## System Overview

**LBDI Corporation - Multi-Location Attendance Management System**

A comprehensive enterprise solution for employee attendance tracking with offline sync capability, leave management, and role-based access control.

---

## High-Level System Architecture

```
┌─────────────────────────────────────────────────────────────────────────────────┐
│                           REAL-TIME SIGN-IN SYSTEM                              │
├─────────────────────────────────────────────────────────────────────────────────┤
│                                                                                 │
│  ┌─────────────┐    ┌─────────────┐    ┌─────────────┐    ┌─────────────┐      │
│  │   WEB APP   │    │ MOBILE APP  │    │  QR CODES   │    │  BIOMETRIC  │      │
│  │  (Browser)  │    │  (Offline)  │    │  (Scanner)  │    │  (Device)   │      │
│  └──────┬──────┘    └──────┬──────┘    └──────┬──────┘    └──────┬──────┘      │
│         │                  │                  │                  │              │
│         └──────────────────┼──────────────────┼──────────────────┘              │
│                            │                  │                                 │
│                            ▼                  ▼                                 │
│                    ┌───────────────────────────────────┐                        │
│                    │         REST API LAYER            │                        │
│                    │     (CodeIgniter 4 / PHP 8.1+)    │                        │
│                    └───────────────┬───────────────────┘                        │
│                                    │                                            │
│                                    ▼                                            │
│                    ┌───────────────────────────────────┐                        │
│                    │         DATABASE (MySQL)          │                        │
│                    │   Users│Employees│Attendance│Leave │                        │
│                    └───────────────────────────────────┘                        │
│                                                                                 │
└─────────────────────────────────────────────────────────────────────────────────┘
```

---

## 1. User Authentication Flow

```
                              ┌─────────────────┐
                              │   START LOGIN   │
                              └────────┬────────┘
                                       │
                                       ▼
                              ┌─────────────────┐
                              │  User visits    │
                              │  login page     │
                              └────────┬────────┘
                                       │
                                       ▼
                              ┌─────────────────┐
                              │  Enter Username │
                              │  & Password     │
                              └────────┬────────┘
                                       │
                                       ▼
                          ┌────────────────────────┐
                          │  Validate Credentials  │
                          │  (BCRYPT Hash Check)   │
                          └───────────┬────────────┘
                                      │
                         ┌────────────┴────────────┐
                         │                         │
                         ▼                         ▼
               ┌─────────────────┐       ┌─────────────────┐
               │    INVALID     │       │     VALID       │
               └────────┬────────┘       └────────┬────────┘
                        │                         │
                        ▼                         ▼
               ┌─────────────────┐       ┌─────────────────┐
               │  Log Failed     │       │  Create Session │
               │  Attempt        │       │  with User Data │
               └────────┬────────┘       └────────┬────────┘
                        │                         │
                        ▼                         ▼
               ┌─────────────────┐       ┌─────────────────┐
               │  Show Error     │       │  Load User Role │
               │  Message        │       │  & Permissions  │
               └────────┬────────┘       └────────┬────────┘
                        │                         │
                        ▼                         ▼
               ┌─────────────────┐       ┌─────────────────┐
               │  Return to      │       │  Log Successful │
               │  Login Page     │       │  Login (Audit)  │
               └─────────────────┘       └────────┬────────┘
                                                  │
                                                  ▼
                                         ┌─────────────────┐
                                         │  Redirect to    │
                                         │  DASHBOARD      │
                                         └─────────────────┘
```

---

## 2. Daily Attendance Tracking Flow

```
┌─────────────────────────────────────────────────────────────────────────────────┐
│                         DAILY ATTENDANCE WORKFLOW                               │
└─────────────────────────────────────────────────────────────────────────────────┘

    ┌─────────────┐                                           ┌─────────────┐
    │  EMPLOYEE   │                                           │   SYSTEM    │
    │   ACTIONS   │                                           │  TRACKING   │
    └──────┬──────┘                                           └──────┬──────┘
           │                                                         │
           │  ┌──────────────────────────────────────────┐          │
           │  │           SIGN-IN METHODS                │          │
           │  │  ┌─────┐  ┌─────┐  ┌─────┐  ┌────────┐  │          │
           │  │  │ QR  │  │Face │  │Bio- │  │Manual  │  │          │
           │  │  │Code │  │Scan │  │metric│  │Entry  │  │          │
           │  │  └──┬──┘  └──┬──┘  └──┬──┘  └───┬────┘  │          │
           │  │     └────────┼───────┼─────────┘        │          │
           │  └──────────────┼───────┼──────────────────┘          │
           │                 │       │                              │
           ▼                 ▼       ▼                              │
    ┌─────────────┐    ┌───────────────────┐                        │
    │   SIGN IN   │───▶│ Record Sign-In    │───────────────────────▶│
    │  (Morning)  │    │ Time & Method     │                        │
    └──────┬──────┘    └───────────────────┘                        │
           │                                                        │
           │                                        ┌───────────────┴───────────────┐
           │                                        │  • Calculate if LATE          │
           │                                        │  • Compare to 8:00 AM start   │
           │                                        │  • Record late_minutes        │
           │                                        └───────────────┬───────────────┘
           │                                                        │
           ▼                                                        │
    ┌─────────────┐    ┌───────────────────┐                        │
    │ LUNCH OUT   │───▶│ Record Lunch Out  │───────────────────────▶│
    │  (12:00 PM) │    │ Time              │                        │
    └──────┬──────┘    └───────────────────┘                        │
           │                                                        │
           ▼                                                        │
    ┌─────────────┐    ┌───────────────────┐                        │
    │ LUNCH IN    │───▶│ Record Lunch In   │───────────────────────▶│
    │  (1:00 PM)  │    │ Calculate Duration│                        │
    └──────┬──────┘    └───────────────────┘                        │
           │                                        ┌───────────────┴───────────────┐
           │                                        │  • Calculate lunch_duration   │
           │                                        │  • Flag if exceeds 1 hour     │
           │                                        └───────────────┬───────────────┘
           ▼                                                        │
    ┌─────────────┐    ┌───────────────────┐                        │
    │  SIGN OUT   │───▶│ Record Sign-Out   │───────────────────────▶│
    │  (End Day)  │    │ Time              │                        │
    └─────────────┘    └───────────────────┘                        │
                                                    ┌───────────────┴───────────────┐
                                                    │  FINAL CALCULATIONS:          │
                                                    │  • Total working_hours        │
                                                    │  • Overtime calculation       │
                                                    │  • Attendance status          │
                                                    │  • Store complete record      │
                                                    └───────────────────────────────┘
```

---

## 3. Mobile App Offline Sync Flow

```
                    ┌─────────────────────────────────────────────┐
                    │              MOBILE APP SYNC                │
                    └─────────────────────────────────────────────┘

     ┌───────────────────────┐                    ┌───────────────────────┐
     │    OFFLINE MODE       │                    │    ONLINE MODE        │
     │   (No Internet)       │                    │   (Connected)         │
     └───────────┬───────────┘                    └───────────┬───────────┘
                 │                                            │
                 ▼                                            │
     ┌───────────────────────┐                                │
     │  Employee signs in    │                                │
     │  via QR/Face/Bio      │                                │
     └───────────┬───────────┘                                │
                 │                                            │
                 ▼                                            │
     ┌───────────────────────┐                                │
     │  Generate local_uuid  │                                │
     │  (unique identifier)  │                                │
     └───────────┬───────────┘                                │
                 │                                            │
                 ▼                                            │
     ┌───────────────────────┐                                │
     │  Store device_time    │                                │
     │  (phone timestamp)    │                                │
     └───────────┬───────────┘                                │
                 │                                            │
                 ▼                                            │
     ┌───────────────────────┐                                │
     │  Queue in Local       │                                │
     │  Storage              │                                │
     └───────────┬───────────┘                                │
                 │                                            │
                 │    ┌─────────────────┐                     │
                 └───▶│ INTERNET COMES  │◀────────────────────┘
                      │ BACK ONLINE     │
                      └────────┬────────┘
                               │
                               ▼
                      ┌─────────────────┐
                      │  POST request   │
                      │  /api/sync      │
                      └────────┬────────┘
                               │
                               ▼
                      ┌─────────────────────────┐
                      │  Server checks for      │
                      │  duplicate (local_uuid) │
                      └────────────┬────────────┘
                                   │
                      ┌────────────┴────────────┐
                      │                         │
                      ▼                         ▼
             ┌─────────────────┐       ┌─────────────────┐
             │   DUPLICATE     │       │   NEW RECORD    │
             │   (Skip)        │       │   (Process)     │
             └────────┬────────┘       └────────┬────────┘
                      │                         │
                      │                         ▼
                      │                ┌─────────────────┐
                      │                │  Save to        │
                      │                │  Attendance DB  │
                      │                └────────┬────────┘
                      │                         │
                      └────────────┬────────────┘
                                   │
                                   ▼
                      ┌─────────────────────────┐
                      │  Return success to      │
                      │  mobile app             │
                      └────────────┬────────────┘
                                   │
                                   ▼
                      ┌─────────────────────────┐
                      │  Clear local queue      │
                      └─────────────────────────┘
```

---

## 4. Leave Request Workflow

```
┌─────────────────────────────────────────────────────────────────────────────────┐
│                          LEAVE REQUEST PROCESS                                  │
└─────────────────────────────────────────────────────────────────────────────────┘

    EMPLOYEE                        SYSTEM                         MANAGER
       │                              │                               │
       ▼                              │                               │
┌─────────────┐                       │                               │
│ Submit Leave│                       │                               │
│ Request     │                       │                               │
│ • Type      │                       │                               │
│ • Dates     │──────────────────────▶│                               │
│ • Reason    │                       │                               │
│ • Document  │                       │                               │
└─────────────┘                       │                               │
                                      ▼                               │
                              ┌─────────────┐                         │
                              │ Create      │                         │
                              │ Request     │                         │
                              │ Status:     │                         │
                              │ PENDING     │────────────────────────▶│
                              └─────────────┘                         │
                                      │                               ▼
                                      │                      ┌─────────────┐
                                      │                      │ Review      │
                                      │                      │ Request     │
                                      │                      │ • Check     │
                                      │                      │   balance   │
                                      │                      │ • Verify    │
                                      │                      │   dates     │
                                      │                      └──────┬──────┘
                                      │                             │
                                      │               ┌─────────────┴─────────────┐
                                      │               │                           │
                                      │               ▼                           ▼
                                      │      ┌─────────────┐             ┌─────────────┐
                                      │      │   APPROVE   │             │   REJECT    │
                                      │      └──────┬──────┘             └──────┬──────┘
                                      │             │                           │
                                      ◀─────────────┴───────────────────────────┘
                                      │
                     ┌────────────────┴────────────────┐
                     │                                 │
                     ▼                                 ▼
            ┌─────────────────┐               ┌─────────────────┐
            │  IF APPROVED:   │               │  IF REJECTED:   │
            │ • Update status │               │ • Update status │
            │ • Deduct leave  │               │ • Add rejection │
            │   balance       │               │   reason        │
            │ • Mark dates    │               └────────┬────────┘
            │   as "On Leave" │                        │
            └────────┬────────┘                        │
                     │                                 │
                     └─────────────────┬───────────────┘
                                       │
                                       ▼
                              ┌─────────────────┐
                              │  Create Audit   │
                              │  Log Entry      │
                              └────────┬────────┘
                                       │
                                       ▼
                              ┌─────────────────┐
                              │  Notify         │
                              │  Employee       │
                              └─────────────────┘
```

---

## 5. Role-Based Access Control

```
┌─────────────────────────────────────────────────────────────────────────────────┐
│                        PERMISSION HIERARCHY                                     │
└─────────────────────────────────────────────────────────────────────────────────┘

                              ┌─────────────────┐
                              │  SUPER ADMIN    │
                              │  (Full Access)  │
                              └────────┬────────┘
                                       │
           ┌───────────────────────────┼───────────────────────────┐
           │                           │                           │
           ▼                           ▼                           ▼
   ┌─────────────────┐       ┌─────────────────┐       ┌─────────────────┐
   │   HR MANAGER    │       │ BRANCH MANAGER  │       │ DEPARTMENT HEAD │
   │                 │       │                 │       │                 │
   │ • All employees │       │ • Location only │       │ • Department    │
   │ • All reports   │       │ • Local reports │       │   only          │
   │ • Leave mgmt    │       │ • Leave approve │       │ • Dept reports  │
   │ • User mgmt     │       │                 │       │                 │
   └─────────────────┘       └─────────────────┘       └─────────────────┘
                                       │
                                       ▼
                              ┌─────────────────┐
                              │     VIEWER      │
                              │  (Read Only)    │
                              │                 │
                              │ • View reports  │
                              │ • View records  │
                              │ • No editing    │
                              └─────────────────┘

┌─────────────────────────────────────────────────────────────────────────────────┐
│  31 GRANULAR PERMISSIONS ACROSS 8 MODULES:                                      │
│                                                                                 │
│  ┌──────────────┐  ┌──────────────┐  ┌──────────────┐  ┌──────────────┐        │
│  │  EMPLOYEES   │  │  ATTENDANCE  │  │    LEAVE     │  │   REPORTS    │        │
│  │  • view      │  │  • view      │  │  • view      │  │  • generate  │        │
│  │  • create    │  │  • manage    │  │  • create    │  │  • export    │        │
│  │  • edit      │  │  • manual    │  │  • approve   │  │  • schedule  │        │
│  │  • delete    │  │  • correct   │  │  • manage    │  │              │        │
│  │  • import    │  │              │  │              │  │              │        │
│  └──────────────┘  └──────────────┘  └──────────────┘  └──────────────┘        │
│                                                                                 │
│  ┌──────────────┐  ┌──────────────┐  ┌──────────────┐  ┌──────────────┐        │
│  │    USERS     │  │    ROLES     │  │  LOCATIONS   │  │    AUDIT     │        │
│  │  • view      │  │  • manage    │  │  • manage    │  │  • view      │        │
│  │  • create    │  │              │  │              │  │  • export    │        │
│  │  • edit      │  │              │  │              │  │  • clear     │        │
│  │  • delete    │  │              │  │              │  │              │        │
│  └──────────────┘  └──────────────┘  └──────────────┘  └──────────────┘        │
│                                                                                 │
└─────────────────────────────────────────────────────────────────────────────────┘
```

---

## 6. Complete System Flow Overview

```
┌─────────────────────────────────────────────────────────────────────────────────┐
│                       COMPLETE SYSTEM FLOW                                      │
└─────────────────────────────────────────────────────────────────────────────────┘

                    ┌─────────────────────────────────────┐
                    │         INITIAL SETUP               │
                    │  • Configure locations (16 sites)   │
                    │  • Configure departments (10)       │
                    │  • Set working hours & thresholds   │
                    │  • Create user roles & permissions  │
                    └──────────────────┬──────────────────┘
                                       │
                                       ▼
                    ┌─────────────────────────────────────┐
                    │       EMPLOYEE ONBOARDING           │
                    │  • Create employee records          │
                    │  • Assign to location/department    │
                    │  • Generate QR codes                │
                    │  • Capture facial recognition data  │
                    │  • Convert to system user (optional)│
                    └──────────────────┬──────────────────┘
                                       │
         ┌─────────────────────────────┼─────────────────────────────┐
         │                             │                             │
         ▼                             ▼                             ▼
┌─────────────────┐         ┌─────────────────┐         ┌─────────────────┐
│   ATTENDANCE    │         │     LEAVE       │         │    REPORTS      │
│   MANAGEMENT    │         │   MANAGEMENT    │         │   & ANALYTICS   │
│                 │         │                 │         │                 │
│ • Daily sign-in │         │ • Request       │         │ • Generate      │
│ • Lunch tracking│         │ • Review        │         │ • Export        │
│ • Sign-out      │         │ • Approve/Deny  │         │ • Schedule      │
│ • Corrections   │         │ • Balance track │         │ • Dashboard     │
│ • Mobile sync   │         │ • Calendar view │         │                 │
└────────┬────────┘         └────────┬────────┘         └────────┬────────┘
         │                           │                           │
         └─────────────────────────────────────────────────────────┘
                                     │
                                     ▼
                    ┌─────────────────────────────────────┐
                    │          AUDIT & SECURITY           │
                    │  • All actions logged               │
                    │  • IP & user agent tracking         │
                    │  • Login attempt monitoring         │
                    │  • Role-based access enforcement    │
                    └─────────────────────────────────────┘
```

---

## 7. Dashboard Statistics Flow

```
┌─────────────────────────────────────────────────────────────────────────────────┐
│                         DASHBOARD REAL-TIME UPDATES                             │
└─────────────────────────────────────────────────────────────────────────────────┘

                              ┌─────────────────┐
                              │  User Opens     │
                              │  Dashboard      │
                              └────────┬────────┘
                                       │
                                       ▼
                     ┌─────────────────────────────────┐
                     │      INITIAL DATA LOAD          │
                     │  • Total employees              │
                     │  • Present today                │
                     │  • Late arrivals                │
                     │  • Absent count                 │
                     │  • Pending leave requests       │
                     │  • Attendance trends (7 days)   │
                     │  • Department breakdown         │
                     └─────────────────┬───────────────┘
                                       │
                                       ▼
                     ┌─────────────────────────────────┐
                     │  Location-Aware Filtering       │
                     │  (Managers see only their site) │
                     └─────────────────┬───────────────┘
                                       │
                                       ▼
                              ┌─────────────────┐
                              │  Display Stats  │
                              │  on Dashboard   │
                              └────────┬────────┘
                                       │
                                       ▼
                     ┌─────────────────────────────────┐
                     │      AUTO-REFRESH CYCLE         │
                     │      (Every 5 minutes)          │
                     │                                 │
                     │  ┌─────────────────────────┐    │
                     │  │ GET /api/dashboard-stats│    │
                     │  └────────────┬────────────┘    │
                     │               │                 │
                     │               ▼                 │
                     │  ┌─────────────────────────┐    │
                     │  │ Update Statistics Cards │    │
                     │  │ • Attendance rate       │    │
                     │  │ • Pending leaves        │    │
                     │  │ • Reports this month    │    │
                     │  └────────────┬────────────┘    │
                     │               │                 │
                     │               ▼                 │
                     │  ┌─────────────────────────┐    │
                     │  │ Color-Coded Indicators  │    │
                     │  │ 🟢 ≥80% Green           │    │
                     │  │ 🟡 60-79% Yellow        │    │
                     │  │ 🔴 <60% Red             │    │
                     │  └─────────────────────────┘    │
                     │                                 │
                     └─────────────────────────────────┘
```

---

## 8. Technology Stack Summary

```
┌─────────────────────────────────────────────────────────────────────────────────┐
│                          TECHNOLOGY STACK                                       │
├─────────────────────────────────────────────────────────────────────────────────┤
│                                                                                 │
│  ┌─────────────────────────────────────────────────────────────────────────┐   │
│  │                            FRONTEND                                     │   │
│  │  ┌──────────────┐  ┌──────────────┐  ┌──────────────┐  ┌────────────┐  │   │
│  │  │  Bootstrap   │  │ Font Awesome │  │    jQuery    │  │    AJAX    │  │   │
│  │  │    5.3.0     │  │    6.4.0     │  │              │  │  (Polling) │  │   │
│  │  └──────────────┘  └──────────────┘  └──────────────┘  └────────────┘  │   │
│  └─────────────────────────────────────────────────────────────────────────┘   │
│                                                                                 │
│  ┌─────────────────────────────────────────────────────────────────────────┐   │
│  │                            BACKEND                                      │   │
│  │  ┌──────────────┐  ┌──────────────┐  ┌──────────────┐  ┌────────────┐  │   │
│  │  │ CodeIgniter  │  │   PHP 8.1+   │  │   RESTful    │  │   BCRYPT   │  │   │
│  │  │      4       │  │              │  │     API      │  │   Hashing  │  │   │
│  │  └──────────────┘  └──────────────┘  └──────────────┘  └────────────┘  │   │
│  └─────────────────────────────────────────────────────────────────────────┘   │
│                                                                                 │
│  ┌─────────────────────────────────────────────────────────────────────────┐   │
│  │                            DATABASE                                     │   │
│  │  ┌──────────────┐  ┌──────────────┐  ┌──────────────┐  ┌────────────┐  │   │
│  │  │    MySQL     │  │   UTF-8MB4   │  │  Migrations  │  │   Seeds    │  │   │
│  │  │   MariaDB    │  │   Charset    │  │   Support    │  │  (Preload) │  │   │
│  │  └──────────────┘  └──────────────┘  └──────────────┘  └────────────┘  │   │
│  └─────────────────────────────────────────────────────────────────────────┘   │
│                                                                                 │
│  ┌─────────────────────────────────────────────────────────────────────────┐   │
│  │                          INTEGRATIONS                                   │   │
│  │  ┌──────────────┐  ┌──────────────┐  ┌──────────────┐  ┌────────────┐  │   │
│  │  │   QR Code    │  │    Facial    │  │  Biometric   │  │   Mobile   │  │   │
│  │  │  Scanning    │  │ Recognition  │  │   Devices    │  │  App Sync  │  │   │
│  │  └──────────────┘  └──────────────┘  └──────────────┘  └────────────┘  │   │
│  └─────────────────────────────────────────────────────────────────────────┘   │
│                                                                                 │
└─────────────────────────────────────────────────────────────────────────────────┘
```

---

## 9. Key Features Summary

```
┌─────────────────────────────────────────────────────────────────────────────────┐
│                           KEY FEATURES                                          │
├─────────────────────────────────────────────────────────────────────────────────┤
│                                                                                 │
│  ✓ MULTI-LOCATION SUPPORT         ✓ MOBILE OFFLINE SYNC                        │
│    • 16 branch locations            • Works without internet                    │
│    • Location-aware filtering       • Auto-syncs when online                    │
│    • Branch-specific reporting      • Duplicate prevention                      │
│                                                                                 │
│  ✓ MULTIPLE SIGN-IN METHODS       ✓ LEAVE MANAGEMENT                           │
│    • QR Code scanning               • 8 leave types                             │
│    • Facial recognition             • Approval workflow                         │
│    • Biometric devices              • Balance tracking                          │
│    • Manual entry                   • Calendar view                             │
│                                                                                 │
│  ✓ COMPREHENSIVE REPORTING        ✓ ROLE-BASED SECURITY                        │
│    • Attendance reports             • 5 user roles                              │
│    • Leave usage reports            • 31 granular permissions                   │
│    • Export: PDF, Excel, CSV        • Complete audit trail                      │
│    • Scheduled auto-reports         • IP/activity logging                       │
│                                                                                 │
│  ✓ REAL-TIME DASHBOARD            ✓ EMPLOYEE MANAGEMENT                        │
│    • Live attendance stats          • Employee profiles                         │
│    • Trend analysis (7 days)        • Bulk import                               │
│    • Department breakdown           • Photo & QR generation                     │
│    • Auto-refresh every 5 min       • User account conversion                   │
│                                                                                 │
└─────────────────────────────────────────────────────────────────────────────────┘
```

---

## 10. Database Entity Relationship (Simplified)

```
┌─────────────────────────────────────────────────────────────────────────────────┐
│                      DATABASE RELATIONSHIPS                                     │
└─────────────────────────────────────────────────────────────────────────────────┘

    ┌─────────────┐         ┌─────────────┐         ┌─────────────┐
    │   ROLES     │◀────────│    USERS    │────────▶│  LOCATIONS  │
    │             │         │             │         │             │
    │ • id        │    1:N  │ • id        │  N:1    │ • id        │
    │ • name      │         │ • username  │         │ • name      │
    │ • slug      │         │ • email     │         │ • code      │
    └──────┬──────┘         │ • role_id   │         │ • address   │
           │                │ • location_id│         └─────────────┘
           │                └──────┬──────┘
           │                       │
           ▼                       │
    ┌─────────────┐               │
    │ PERMISSIONS │               │
    │             │               │
    │ • id        │               │
    │ • name      │               │
    │ • slug      │               │
    │ • module    │               │
    └─────────────┘               │
                                  │
    ┌─────────────┐               │         ┌─────────────┐
    │ DEPARTMENTS │◀──────────────┼─────────│  EMPLOYEES  │
    │             │               │         │             │
    │ • id        │          N:1  │    N:1  │ • id        │
    │ • name      │               │         │ • emp_number│
    │ • code      │               │         │ • name      │
    └─────────────┘               │         │ • department│
                                  │         │ • location_id│
                                  │         │ • qr_code   │
                                  │         │ • facial_data│
                                  │         └──────┬──────┘
                                  │                │
                           ┌──────┴──────┐         │
                           │             │         │
                           ▼             ▼         ▼
                    ┌─────────────┐  ┌─────────────────┐
                    │ AUDIT_LOGS  │  │   ATTENDANCE    │
                    │             │  │                 │
                    │ • user_id   │  │ • employee_id   │
                    │ • action    │  │ • date          │
                    │ • module    │  │ • sign_in_time  │
                    │ • ip_address│  │ • sign_out_time │
                    │ • timestamp │  │ • lunch_out/in  │
                    └─────────────┘  │ • working_hours │
                                     │ • is_late       │
                                     │ • method        │
                                     └────────┬────────┘
                                              │
                                              │
                    ┌─────────────┐           │      ┌─────────────┐
                    │ LEAVE_TYPES │◀──────────┼─────▶│LEAVE_REQUEST│
                    │             │           │      │             │
                    │ • id        │      N:1  │  1:N │ • id        │
                    │ • name      │           │      │ • employee_id│
                    │ • days/year │           │      │ • type_id   │
                    │ • is_paid   │           │      │ • start/end │
                    └─────────────┘           │      │ • status    │
                                              │      │ • approved_by│
                                              │      └─────────────┘
                                              │
                                              ▼
                                     ┌─────────────────┐
                                     │  LEAVE_BALANCES │
                                     │                 │
                                     │ • employee_id   │
                                     │ • leave_type_id │
                                     │ • year          │
                                     │ • total_days    │
                                     │ • used_days     │
                                     └─────────────────┘
```

---

## Summary for Client

This **Real-Time Sign-In System** provides:

1. **Enterprise-Grade Attendance Management** across 16 locations
2. **Flexible Sign-In Options**: QR codes, facial recognition, biometric, manual
3. **Mobile-First Design** with offline capability and auto-sync
4. **Complete Leave Management** with approval workflows
5. **Comprehensive Reporting** with scheduled automation
6. **Robust Security** with role-based access and audit logging
7. **Scalable Architecture** built on CodeIgniter 4 and MySQL

The system is designed for organizations that need to track employee attendance across multiple locations while maintaining security, compliance, and ease of use.

---

*Generated for LBDI Corporation - Multi-Location Attendance Management System*
