# Synchronization Settings Documentation

## Overview
The Synchronization Settings provide comprehensive control over how the system handles offline attendance data synced from mobile devices. This feature is crucial for organizations where mobile devices may operate in areas with limited connectivity.

---

## Features

✅ **Offline Sync Support** - Mobile devices can collect attendance offline and sync later
✅ **Conflict Resolution** - Choose how to handle duplicate or conflicting records
✅ **Batch Processing** - Control sync performance with configurable batch sizes
✅ **Automatic Cleanup** - Keep database clean with auto-cleanup of old sync logs
✅ **Duplicate Detection** - Prevent duplicate attendance records
✅ **Email Notifications** - Get notified of sync errors
✅ **Live Statistics** - View sync performance metrics in real-time

---

## Installation

### Step 1: Run the SQL Script

Execute the SQL script to add synchronization settings:

```bash
# Using command line
mysql -u your_username -p your_database < SYNCHRONIZATION_SETTINGS_SETUP.sql

# Or copy and paste from SYNCHRONIZATION_SETTINGS_SETUP.sql into phpMyAdmin
```

### Step 2: Verify Installation

1. Log in as administrator
2. Go to **Settings > System Settings**
3. Click on the **Synchronization** tab
4. You should see 8 synchronization settings

---

## Settings Reference

### 1. Enable Offline Sync
**Type:** Toggle (Boolean)
**Default:** ON
**Description:** Master switch to enable/disable offline synchronization feature

**When to disable:**
- During system maintenance
- If you want to force real-time only attendance
- Troubleshooting sync issues

### 2. Sync Conflict Resolution
**Type:** Select Dropdown
**Default:** Server Wins
**Options:**
- **Server Wins** - Server data takes priority over mobile data
- **Client Wins** - Mobile data takes priority over server data
- **Manual Review** - Conflicts require administrator review

**Recommendation:** Use "Server Wins" for most cases to maintain data integrity.

### 3. Sync Batch Size
**Type:** Number
**Default:** 100
**Range:** 1 - 1000
**Description:** Maximum number of records processed in a single sync batch

**Performance Guide:**
- **Small (10-50):** Slower but more reliable for poor connections
- **Medium (50-100):** Balanced performance (Recommended)
- **Large (100-500):** Faster but may timeout on slow connections

### 4. Sync Retention Days
**Type:** Number
**Default:** 30
**Range:** 7 - 365
**Description:** How long to keep sync transaction logs before deletion

**Common Settings:**
- **7 days:** Minimal storage, recent history only
- **30 days:** Recommended for most organizations
- **90 days:** Extended history for compliance
- **365 days:** Full year retention for auditing

### 5. Enable Auto Sync Cleanup
**Type:** Toggle (Boolean)
**Default:** ON
**Description:** Automatically delete old sync logs based on retention period

**Benefits:**
- Keeps database size manageable
- Improves query performance
- Reduces storage costs

**When to disable:**
- If you have external backup processes
- During investigations of sync issues
- For compliance requiring manual deletion

### 6. Sync Notification Email
**Type:** Text Field
**Default:** Empty
**Description:** Email address to receive sync error notifications

**Example:** `admin@company.com` or `it-support@company.com`

**Notifications include:**
- Failed sync attempts
- Conflict resolution failures
- Duplicate detection alerts
- System errors during sync

**Leave empty to disable email notifications.**

### 7. Enable Duplicate Detection
**Type:** Toggle (Boolean)
**Default:** ON
**Description:** Prevent duplicate attendance records during synchronization

**How it works:**
- Checks `local_uuid` for exact duplicates
- Uses time tolerance to detect near-duplicates
- Automatically skips duplicate records

**When to disable:**
- Testing sync functionality
- Initial data migration
- Troubleshooting specific sync issues

### 8. Sync Time Tolerance Minutes
**Type:** Number
**Default:** 5
**Range:** 1 - 60
**Description:** Time window (in minutes) for detecting duplicate records

**Examples:**
- **Tolerance: 5 minutes**
  - Record A: Sign-in at 08:00:00
  - Record B: Sign-in at 08:04:00
  - Result: Considered duplicate (within 5 min window)

- **Tolerance: 1 minute**
  - Record A: Sign-in at 08:00:00
  - Record B: Sign-in at 08:04:00
  - Result: Both saved (outside 1 min window)

**Recommendation:** 5 minutes for most cases

---

## Sync Statistics Dashboard

The Synchronization settings page includes a live statistics dashboard showing:

### Metrics Displayed

1. **Total Synced (30 days)**
   - Number of attendance records synced from mobile devices
   - Rolling 30-day window
   - Auto-updates when settings are opened

2. **Success Rate**
   - Percentage of successful sync operations
   - Calculated: (Synced Records / Total Records) × 100
   - Green: >95%, Yellow: 80-95%, Red: <80%

3. **Pending Review**
   - Number of records requiring manual review
   - Shown when Conflict Resolution = "Manual Review"
   - Administrators must review and approve these records

### Refreshing Statistics

Click the **"Refresh Statistics"** button to update metrics in real-time.

---

## How Synchronization Works

### Mobile Device Workflow

1. **Offline Mode**
   - Mobile app collects attendance (sign-in, sign-out, lunch)
   - Data stored locally on device with `local_uuid`
   - App continues functioning without internet

2. **Sync Trigger**
   - When connectivity restored
   - Manual sync button pressed
   - Scheduled automatic sync (every X minutes)

3. **Data Transmission**
   - Batches of records sent to API endpoint
   - Each record identified by unique `local_uuid`
   - Server processes based on settings

4. **Server Processing**
   - Validates record integrity
   - Checks for duplicates using `local_uuid`
   - Applies conflict resolution rules
   - Saves to attendance table

5. **Response to Mobile**
   - Success: Record marked as synced
   - Already Synced: Skip on mobile
   - Error: Retry later

### API Endpoint

**POST** `/api/attendance/sync`

See [API_SYNC_SETUP.md](API_SYNC_SETUP.md) for complete API documentation.

---

## Conflict Resolution Scenarios

### Scenario 1: Server Wins (Default)

**Situation:** Employee signs in on mobile (offline) at 8:00 AM, but manager already recorded them as signing in at 8:15 AM on the server.

**Result:**
- Server record (8:15 AM) is kept
- Mobile record (8:00 AM) is discarded
- Mobile app updated with server time

### Scenario 2: Client Wins

**Situation:** Same as above

**Result:**
- Mobile record (8:00 AM) overwrites server
- Server record (8:15 AM) is replaced
- Mobile time takes priority

### Scenario 3: Manual Review

**Situation:** Same as above

**Result:**
- Both records flagged for review
- Administrator sees both timestamps
- Admin manually chooses which to keep
- Rejected record is archived

---

## Best Practices

### 1. Initial Configuration

✅ **DO:**
- Start with default settings
- Test with a small group of users
- Monitor statistics for first week
- Adjust based on actual usage

❌ **DON'T:**
- Change all settings at once
- Disable duplicate detection without reason
- Set very short retention periods
- Ignore sync error notifications

### 2. Production Environment

✅ **DO:**
- Enable offline sync
- Use "Server Wins" conflict resolution
- Set notification email to IT support
- Keep auto cleanup enabled
- Monitor statistics weekly

❌ **DON'T:**
- Disable offline sync unless necessary
- Use "Client Wins" without consideration
- Leave notification email empty
- Manually delete sync logs
- Ignore declining success rates

### 3. Troubleshooting

When sync issues occur:

1. Check Statistics Dashboard
2. Review recent sync error logs
3. Verify notification emails
4. Test with single record
5. Check conflict resolution setting
6. Verify duplicate detection tolerance

### 4. Performance Optimization

**For Slow Networks:**
- Reduce batch size to 25-50
- Increase time tolerance to 10 minutes
- Enable all duplicate detection

**For Fast Networks:**
- Increase batch size to 200-500
- Keep standard time tolerance (5 min)
- Standard settings work well

**For High Volume:**
- Increase batch size to 500
- Reduce retention to 14 days
- Enable auto cleanup
- Monitor database size

---

## Monitoring & Maintenance

### Daily Checks
- View sync statistics dashboard
- Check for email notifications
- Verify success rate >95%

### Weekly Tasks
- Review pending records (if manual review enabled)
- Check database size growth
- Verify cleanup is running

### Monthly Tasks
- Analyze sync trends
- Adjust settings if needed
- Review retention period
- Test disaster recovery

---

## Troubleshooting Guide

### Issue: Low Success Rate (<80%)

**Possible Causes:**
- Network connectivity issues
- Mobile app outdated
- Server overload
- Database issues

**Solutions:**
1. Check server logs for errors
2. Verify API endpoint is accessible
3. Test with single device
4. Update mobile app
5. Check database performance

### Issue: High Number of Pending Records

**Cause:** Conflict Resolution set to "Manual Review"

**Solutions:**
1. Review pending records in admin panel
2. Approve or reject each record
3. Consider switching to "Server Wins"
4. Train staff on proper sync procedures

### Issue: Duplicates Still Being Created

**Possible Causes:**
- Time tolerance too low
- Duplicate detection disabled
- Different `local_uuid` for same record

**Solutions:**
1. Increase time tolerance to 10 minutes
2. Verify duplicate detection is enabled
3. Check mobile app `local_uuid` generation
4. Review database for patterns

### Issue: Sync Taking Too Long

**Possible Causes:**
- Batch size too small
- Large backlog of records
- Server performance issues

**Solutions:**
1. Increase batch size to 200-500
2. Schedule bulk sync during off-hours
3. Optimize database indexes
4. Scale server resources

---

## Security Considerations

### API Access
- Sync API endpoint has no authentication (by design)
- Consider IP whitelisting for production
- Monitor for abuse via statistics
- Log all sync attempts

### Data Integrity
- `local_uuid` ensures uniqueness
- Duplicate detection prevents data corruption
- Conflict resolution protects server data
- Audit logs track all changes

### Compliance
- Sync logs provide audit trail
- Retention period supports compliance requirements
- Email notifications create paper trail
- Manual review option for sensitive data

---

## API Integration

The sync settings work seamlessly with the attendance sync API:

**Endpoint:** `POST /api/attendance/sync`
**Statistics:** `GET /api/sync/statistics`

See complete API documentation in [API_SYNC_SETUP.md](API_SYNC_SETUP.md)

---

## Database Schema

### Tables Affected

**attendance table:**
- `local_uuid` - Unique identifier from mobile device
- `device_time` - Timestamp from mobile when created
- Standard attendance fields

### Indexes
- `local_uuid` - Unique index for fast duplicate checks
- `created_at` - For statistics queries
- `device_time` - For conflict resolution

---

## Future Enhancements

Potential improvements:

- Sync conflict history table
- Visual sync timeline
- Real-time sync monitoring dashboard
- Advanced duplicate detection algorithms
- Multi-device sync coordination
- Sync performance analytics
- Automated issue resolution
- Machine learning for conflict prediction

---

## Support

For assistance:
1. Check system logs: `writable/logs/log-YYYY-MM-DD.log`
2. Review statistics dashboard
3. Check email notifications
4. Contact system administrator

---

## Summary

The Synchronization Settings provide powerful control over offline data sync:

✅ Flexible conflict resolution
✅ Automatic duplicate prevention
✅ Performance optimization
✅ Maintenance automation
✅ Real-time monitoring
✅ Error notifications
✅ Compliance support

**Recommended Starting Configuration:**
- Enable Offline Sync: ✅ ON
- Conflict Resolution: Server Wins
- Batch Size: 100
- Retention Days: 30
- Auto Cleanup: ✅ ON
- Duplicate Detection: ✅ ON
- Time Tolerance: 5 minutes
- Notification Email: your-email@company.com

Adjust based on your organization's needs! 🎉
