-- SQL script to add synchronization settings
-- Run this in your database if you cannot run migrations due to PHP version

-- Insert synchronization settings
INSERT INTO `system_settings` (`key`, `value`, `type`, `description`, `is_public`, `created_at`, `updated_at`) VALUES
('enable_offline_sync', '1', 'boolean', 'Enable offline attendance synchronization from mobile devices', 0, NOW(), NOW()),
('sync_conflict_resolution', 'server_wins', 'select', 'How to handle conflicts when syncing (server_wins, client_wins, manual)', 0, NOW(), NOW()),
('sync_batch_size', '100', 'number', 'Maximum number of records to sync in a single batch', 0, NOW(), NOW()),
('sync_retention_days', '30', 'number', 'Number of days to keep sync logs before automatic cleanup', 0, NOW(), NOW()),
('enable_auto_sync_cleanup', '1', 'boolean', 'Automatically clean up old sync logs based on retention period', 0, NOW(), NOW()),
('sync_notification_email', '', 'string', 'Email address to receive sync error notifications (leave empty to disable)', 0, NOW(), NOW()),
('enable_duplicate_detection', '1', 'boolean', 'Prevent duplicate attendance records during sync', 0, NOW(), NOW()),
('sync_time_tolerance_minutes', '5', 'number', 'Time difference tolerance (in minutes) when detecting duplicate records', 0, NOW(), NOW());

-- Note: If the records already exist, delete them first:
-- DELETE FROM `system_settings` WHERE `key` IN ('enable_offline_sync', 'sync_conflict_resolution', 'sync_batch_size', 'sync_retention_days', 'enable_auto_sync_cleanup', 'sync_notification_email', 'enable_duplicate_detection', 'sync_time_tolerance_minutes');
