<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AddEmployeeNumberSettings extends Migration
{
    public function up()
    {
        $data = [
            [
                'key' => 'enable_auto_employee_number',
                'value' => '1',
                'type' => 'boolean',
                'description' => 'Automatically generate employee numbers when creating new employees',
                'is_public' => 0,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'key' => 'employee_number_prefix',
                'value' => 'EMP',
                'type' => 'string',
                'description' => 'Prefix for auto-generated employee numbers (e.g., EMP0001, STAFF0001)',
                'is_public' => 0,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'key' => 'employee_number_start',
                'value' => '1',
                'type' => 'number',
                'description' => 'Starting number for auto-generated employee numbers',
                'is_public' => 0,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'key' => 'employee_number_padding',
                'value' => '4',
                'type' => 'number',
                'description' => 'Number of digits for employee number (e.g., 4 = 0001, 5 = 00001)',
                'is_public' => 0,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
        ];

        $this->db->table('system_settings')->insertBatch($data);
    }

    public function down()
    {
        $this->db->table('system_settings')
            ->whereIn('key', [
                'enable_auto_employee_number',
                'employee_number_prefix',
                'employee_number_start',
                'employee_number_padding',
            ])
            ->delete();
    }
}
