<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AddSynchronizationSettings extends Migration
{
    public function up()
    {
        $data = [
            [
                'key' => 'enable_offline_sync',
                'value' => '1',
                'type' => 'boolean',
                'description' => 'Enable offline attendance synchronization from mobile devices',
                'is_public' => 0,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'key' => 'sync_conflict_resolution',
                'value' => 'server_wins',
                'type' => 'select',
                'description' => 'How to handle conflicts when syncing (server_wins, client_wins, manual)',
                'is_public' => 0,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'key' => 'sync_batch_size',
                'value' => '100',
                'type' => 'number',
                'description' => 'Maximum number of records to sync in a single batch',
                'is_public' => 0,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'key' => 'sync_retention_days',
                'value' => '30',
                'type' => 'number',
                'description' => 'Number of days to keep sync logs before automatic cleanup',
                'is_public' => 0,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'key' => 'enable_auto_sync_cleanup',
                'value' => '1',
                'type' => 'boolean',
                'description' => 'Automatically clean up old sync logs based on retention period',
                'is_public' => 0,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'key' => 'sync_notification_email',
                'value' => '',
                'type' => 'string',
                'description' => 'Email address to receive sync error notifications (leave empty to disable)',
                'is_public' => 0,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'key' => 'enable_duplicate_detection',
                'value' => '1',
                'type' => 'boolean',
                'description' => 'Prevent duplicate attendance records during sync',
                'is_public' => 0,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'key' => 'sync_time_tolerance_minutes',
                'value' => '5',
                'type' => 'number',
                'description' => 'Time difference tolerance (in minutes) when detecting duplicate records',
                'is_public' => 0,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
        ];

        $this->db->table('system_settings')->insertBatch($data);
    }

    public function down()
    {
        $this->db->table('system_settings')
            ->whereIn('key', [
                'enable_offline_sync',
                'sync_conflict_resolution',
                'sync_batch_size',
                'sync_retention_days',
                'enable_auto_sync_cleanup',
                'sync_notification_email',
                'enable_duplicate_detection',
                'sync_time_tolerance_minutes',
            ])
            ->delete();
    }
}
