<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateScheduledReportsTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'constraint'     => 11,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'report_name' => [
                'type'       => 'VARCHAR',
                'constraint' => '200',
            ],
            'report_type' => [
                'type'       => 'VARCHAR',
                'constraint' => '50',
                'comment'    => 'attendance, leave, employee, custom',
            ],
            'frequency' => [
                'type'       => 'VARCHAR',
                'constraint' => '20',
                'comment'    => 'daily, weekly, monthly',
            ],
            'schedule_time' => [
                'type'    => 'TIME',
                'comment' => 'Time to run the report',
            ],
            'schedule_day' => [
                'type'       => 'VARCHAR',
                'constraint' => '20',
                'null'       => true,
                'comment'    => 'Day of week (for weekly) or day of month (for monthly)',
            ],
            'filters' => [
                'type'    => 'TEXT',
                'null'    => true,
                'comment' => 'JSON encoded filters (department_id, location_id, etc.)',
            ],
            'format' => [
                'type'       => 'VARCHAR',
                'constraint' => '10',
                'default'    => 'pdf',
                'comment'    => 'pdf, excel, csv',
            ],
            'recipients' => [
                'type'    => 'TEXT',
                'comment' => 'JSON encoded list of email addresses',
            ],
            'is_active' => [
                'type'       => 'TINYINT',
                'constraint' => 1,
                'default'    => 1,
                'comment'    => '1 = Active, 0 = Inactive',
            ],
            'last_run' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'next_run' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'created_by' => [
                'type'       => 'INT',
                'constraint' => 11,
                'unsigned'   => true,
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
        ]);

        $this->forge->addKey('id', true);
        $this->forge->addKey('is_active');
        $this->forge->addKey('next_run');
        $this->forge->createTable('scheduled_reports');
    }

    public function down()
    {
        $this->forge->dropTable('scheduled_reports');
    }
}
