<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class DepartmentSeeder extends Seeder
{
    public function run()
    {
        $departments = [
            [
                'department_code' => 'HR',
                'department_name' => 'Human Resources',
                'description'     => 'Manages recruitment, employee relations, and HR policies',
                'is_active'       => 1,
            ],
            [
                'department_code' => 'IT',
                'department_name' => 'Information Technology',
                'description'     => 'Manages IT infrastructure, software development, and technical support',
                'is_active'       => 1,
            ],
            [
                'department_code' => 'FIN',
                'department_name' => 'Finance',
                'description'     => 'Handles accounting, budgeting, and financial reporting',
                'is_active'       => 1,
            ],
            [
                'department_code' => 'OPS',
                'department_name' => 'Operations',
                'description'     => 'Manages day-to-day business operations',
                'is_active'       => 1,
            ],
            [
                'department_code' => 'SALES',
                'department_name' => 'Sales & Marketing',
                'description'     => 'Handles sales, marketing campaigns, and customer relations',
                'is_active'       => 1,
            ],
            [
                'department_code' => 'CUST',
                'department_name' => 'Customer Service',
                'description'     => 'Provides customer support and handles customer inquiries',
                'is_active'       => 1,
            ],
            [
                'department_code' => 'LOG',
                'department_name' => 'Logistics',
                'description'     => 'Manages supply chain, inventory, and distribution',
                'is_active'       => 1,
            ],
            [
                'department_code' => 'ADM',
                'department_name' => 'Administration',
                'description'     => 'Handles general administrative functions and office management',
                'is_active'       => 1,
            ],
            [
                'department_code' => 'LEG',
                'department_name' => 'Legal & Compliance',
                'description'     => 'Manages legal matters and regulatory compliance',
                'is_active'       => 1,
            ],
            [
                'department_code' => 'PROD',
                'department_name' => 'Production',
                'description'     => 'Oversees manufacturing and production processes',
                'is_active'       => 1,
            ],
        ];

        foreach ($departments as &$department) {
            $department['created_at'] = date('Y-m-d H:i:s');
            $department['updated_at'] = date('Y-m-d H:i:s');
        }

        $this->db->table('departments')->insertBatch($departments);
    }
}
