<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class EmployeeSeeder extends Seeder
{
    public function run()
    {
        // Get some locations and departments for sample employees
        $locations = $this->db->table('locations')->limit(5)->get()->getResultArray();
        $departments = $this->db->table('departments')->get()->getResultArray();

        $employees = [];
        $firstNames = ['Juan', 'Maria', 'Pedro', 'Ana', 'Carlos', 'Sofia', 'Miguel', 'Isabel', 'Jose', 'Carmen',
                       'Luis', 'Rosa', 'Antonio', 'Elena', 'Roberto', 'Patricia', 'Gabriel', 'Laura', 'Fernando', 'Diana'];
        $lastNames = ['Dela Cruz', 'Santos', 'Reyes', 'Garcia', 'Martinez', 'Fernandez', 'Lopez', 'Mendoza',
                      'Torres', 'Ramos', 'Flores', 'Silva', 'Morales', 'Castillo', 'Gomez'];

        // Generate 50 sample employees
        for ($i = 1; $i <= 50; $i++) {
            $firstName = $firstNames[array_rand($firstNames)];
            $lastName = $lastNames[array_rand($lastNames)];
            $location = $locations[array_rand($locations)];
            $department = $departments[array_rand($departments)];

            $employees[] = [
                'employee_id'    => 'EMP-' . str_pad($i, 5, '0', STR_PAD_LEFT),
                'qr_code'        => 'QR-' . strtoupper(bin2hex(random_bytes(8))),
                'first_name'     => $firstName,
                'middle_name'    => chr(65 + rand(0, 25)) . '.',
                'last_name'      => $lastName,
                'email'          => strtolower($firstName . '.' . $lastName . $i . '@lbdi.com'),
                'phone'          => '+63-9' . rand(10, 99) . '-' . rand(100, 999) . '-' . rand(1000, 9999),
                'date_of_birth'  => date('Y-m-d', strtotime('-' . rand(25, 55) . ' years')),
                'gender'         => ['Male', 'Female'][array_rand(['Male', 'Female'])],
                'address'        => rand(1, 999) . ' ' . ['Main', 'Rizal', 'Quezon', 'Luna', 'Del Pilar'][array_rand(['Main', 'Rizal', 'Quezon', 'Luna', 'Del Pilar'])] . ' Street',
                'city'           => $location['city'],
                'province'       => $location['province'],
                'postal_code'    => $location['postal_code'],
                'department_id'  => $department['id'],
                'location_id'    => $location['id'],
                'position'       => ['Staff', 'Senior Staff', 'Supervisor', 'Team Lead', 'Specialist'][array_rand(['Staff', 'Senior Staff', 'Supervisor', 'Team Lead', 'Specialist'])],
                'employment_type' => ['Full-time', 'Part-time', 'Contract'][array_rand(['Full-time', 'Part-time', 'Contract'])],
                'hire_date'      => date('Y-m-d', strtotime('-' . rand(1, 10) . ' years')),
                'is_active'      => 1,
                'created_at'     => date('Y-m-d H:i:s'),
                'updated_at'     => date('Y-m-d H:i:s'),
            ];
        }

        $this->db->table('employees')->insertBatch($employees);

        // Initialize leave balances for all employees
        $this->call('LeaveBalanceSeeder');
    }
}
