<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class LeaveBalanceSeeder extends Seeder
{
    public function run()
    {
        $employees = $this->db->table('employees')->get()->getResultArray();
        $leaveTypes = $this->db->table('leave_types')->get()->getResultArray();
        $currentYear = date('Y');

        $balances = [];

        foreach ($employees as $employee) {
            foreach ($leaveTypes as $leaveType) {
                $totalDays = $leaveType['default_days_per_year'];
                $usedDays = rand(0, min(5, $totalDays)); // Random used days (0-5)
                $pendingDays = rand(0, min(2, $totalDays - $usedDays)); // Random pending days (0-2)
                $remainingDays = $totalDays - $usedDays - $pendingDays;

                $balances[] = [
                    'employee_id'    => $employee['employee_id'],
                    'leave_type_id'  => $leaveType['id'],
                    'year'           => $currentYear,
                    'total_days'     => $totalDays,
                    'used_days'      => $usedDays,
                    'pending_days'   => $pendingDays,
                    'remaining_days' => $remainingDays,
                    'carried_forward' => 0,
                    'created_at'     => date('Y-m-d H:i:s'),
                    'updated_at'     => date('Y-m-d H:i:s'),
                ];
            }
        }

        $this->db->table('leave_balances')->insertBatch($balances);
    }
}
