<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class LeaveTypeSeeder extends Seeder
{
    public function run()
    {
        $leaveTypes = [
            [
                'leave_type_name'      => 'Sick Leave',
                'leave_type_code'      => 'SL',
                'description'          => 'Leave for illness or medical appointments',
                'default_days_per_year' => 15,
                'is_paid'              => 1,
                'requires_document'    => 1,
                'max_consecutive_days' => 7,
                'min_notice_days'      => 0,
                'is_active'            => 1,
                'color_code'           => '#FF6B6B',
            ],
            [
                'leave_type_name'      => 'Personal Leave',
                'leave_type_code'      => 'PL',
                'description'          => 'Personal time off for personal matters',
                'default_days_per_year' => 10,
                'is_paid'              => 1,
                'requires_document'    => 0,
                'max_consecutive_days' => 5,
                'min_notice_days'      => 3,
                'is_active'            => 1,
                'color_code'           => '#4ECDC4',
            ],
            [
                'leave_type_name'      => 'Vacation Leave',
                'leave_type_code'      => 'VL',
                'description'          => 'Annual vacation time off',
                'default_days_per_year' => 20,
                'is_paid'              => 1,
                'requires_document'    => 0,
                'max_consecutive_days' => null,
                'min_notice_days'      => 7,
                'is_active'            => 1,
                'color_code'           => '#95E1D3',
            ],
            [
                'leave_type_name'      => 'Maternity Leave',
                'leave_type_code'      => 'ML',
                'description'          => 'Leave for childbirth and post-natal care',
                'default_days_per_year' => 105,
                'is_paid'              => 1,
                'requires_document'    => 1,
                'max_consecutive_days' => 105,
                'min_notice_days'      => 30,
                'is_active'            => 1,
                'color_code'           => '#FFB6C1',
            ],
            [
                'leave_type_name'      => 'Paternity Leave',
                'leave_type_code'      => 'PTL',
                'description'          => 'Leave for fathers after childbirth',
                'default_days_per_year' => 7,
                'is_paid'              => 1,
                'requires_document'    => 1,
                'max_consecutive_days' => 7,
                'min_notice_days'      => 7,
                'is_active'            => 1,
                'color_code'           => '#87CEEB',
            ],
            [
                'leave_type_name'      => 'Emergency Leave',
                'leave_type_code'      => 'EL',
                'description'          => 'Leave for emergency situations',
                'default_days_per_year' => 5,
                'is_paid'              => 1,
                'requires_document'    => 1,
                'max_consecutive_days' => 3,
                'min_notice_days'      => 0,
                'is_active'            => 1,
                'color_code'           => '#FF4757',
            ],
            [
                'leave_type_name'      => 'Bereavement Leave',
                'leave_type_code'      => 'BL',
                'description'          => 'Leave for death of a family member',
                'default_days_per_year' => 3,
                'is_paid'              => 1,
                'requires_document'    => 1,
                'max_consecutive_days' => 3,
                'min_notice_days'      => 0,
                'is_active'            => 1,
                'color_code'           => '#2F3542',
            ],
            [
                'leave_type_name'      => 'Unpaid Leave',
                'leave_type_code'      => 'UL',
                'description'          => 'Leave without pay',
                'default_days_per_year' => 0,
                'is_paid'              => 0,
                'requires_document'    => 0,
                'max_consecutive_days' => null,
                'min_notice_days'      => 7,
                'is_active'            => 1,
                'color_code'           => '#A4B0BE',
            ],
        ];

        foreach ($leaveTypes as &$leaveType) {
            $leaveType['created_at'] = date('Y-m-d H:i:s');
            $leaveType['updated_at'] = date('Y-m-d H:i:s');
        }

        $this->db->table('leave_types')->insertBatch($leaveTypes);
    }
}
