<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class PermissionSeeder extends Seeder
{
    public function run()
    {
        $permissions = [
            // Dashboard permissions
            ['permission_name' => 'View Dashboard', 'permission_slug' => 'view-dashboard', 'module' => 'Dashboard', 'description' => 'Can view main dashboard'],
            ['permission_name' => 'View Analytics', 'permission_slug' => 'view-analytics', 'module' => 'Dashboard', 'description' => 'Can view analytics and reports'],

            // Employee permissions
            ['permission_name' => 'View Employees', 'permission_slug' => 'view-employees', 'module' => 'Employees', 'description' => 'Can view employee list'],
            ['permission_name' => 'Create Employee', 'permission_slug' => 'create-employee', 'module' => 'Employees', 'description' => 'Can create new employees'],
            ['permission_name' => 'Edit Employee', 'permission_slug' => 'edit-employee', 'module' => 'Employees', 'description' => 'Can edit employee information'],
            ['permission_name' => 'Delete Employee', 'permission_slug' => 'delete-employee', 'module' => 'Employees', 'description' => 'Can delete employees'],
            ['permission_name' => 'Import Employees', 'permission_slug' => 'import-employees', 'module' => 'Employees', 'description' => 'Can bulk import employees'],

            // Attendance permissions
            ['permission_name' => 'View Attendance', 'permission_slug' => 'view-attendance', 'module' => 'Attendance', 'description' => 'Can view attendance records'],
            ['permission_name' => 'Manual Attendance Entry', 'permission_slug' => 'manual-attendance', 'module' => 'Attendance', 'description' => 'Can manually enter attendance'],
            ['permission_name' => 'Edit Attendance', 'permission_slug' => 'edit-attendance', 'module' => 'Attendance', 'description' => 'Can edit attendance records'],
            ['permission_name' => 'Delete Attendance', 'permission_slug' => 'delete-attendance', 'module' => 'Attendance', 'description' => 'Can delete attendance records'],
            ['permission_name' => 'Approve Attendance Corrections', 'permission_slug' => 'approve-attendance-corrections', 'module' => 'Attendance', 'description' => 'Can approve attendance correction requests'],

            // Leave permissions
            ['permission_name' => 'View Leave Requests', 'permission_slug' => 'view-leave-requests', 'module' => 'Leave', 'description' => 'Can view leave requests'],
            ['permission_name' => 'Create Leave Request', 'permission_slug' => 'create-leave-request', 'module' => 'Leave', 'description' => 'Can create leave requests'],
            ['permission_name' => 'Approve Leave', 'permission_slug' => 'approve-leave', 'module' => 'Leave', 'description' => 'Can approve/reject leave requests'],
            ['permission_name' => 'Manage Leave Types', 'permission_slug' => 'manage-leave-types', 'module' => 'Leave', 'description' => 'Can manage leave types'],
            ['permission_name' => 'View Leave Balances', 'permission_slug' => 'view-leave-balances', 'module' => 'Leave', 'description' => 'Can view leave balances'],

            // Report permissions
            ['permission_name' => 'Generate Reports', 'permission_slug' => 'generate-reports', 'module' => 'Reports', 'description' => 'Can generate attendance reports'],
            ['permission_name' => 'Export Reports', 'permission_slug' => 'export-reports', 'module' => 'Reports', 'description' => 'Can export reports to PDF/Excel'],
            ['permission_name' => 'Schedule Reports', 'permission_slug' => 'schedule-reports', 'module' => 'Reports', 'description' => 'Can schedule automated reports'],

            // User & Role permissions
            ['permission_name' => 'View Users', 'permission_slug' => 'view-users', 'module' => 'Users', 'description' => 'Can view system users'],
            ['permission_name' => 'Create User', 'permission_slug' => 'create-user', 'module' => 'Users', 'description' => 'Can create new users'],
            ['permission_name' => 'Edit User', 'permission_slug' => 'edit-user', 'module' => 'Users', 'description' => 'Can edit user information'],
            ['permission_name' => 'Delete User', 'permission_slug' => 'delete-user', 'module' => 'Users', 'description' => 'Can delete users'],
            ['permission_name' => 'Manage Roles', 'permission_slug' => 'manage-roles', 'module' => 'Users', 'description' => 'Can manage roles and permissions'],

            // Location & Department permissions
            ['permission_name' => 'Manage Locations', 'permission_slug' => 'manage-locations', 'module' => 'Settings', 'description' => 'Can manage locations'],
            ['permission_name' => 'Manage Departments', 'permission_slug' => 'manage-departments', 'module' => 'Settings', 'description' => 'Can manage departments'],

            // System permissions
            ['permission_name' => 'View System Settings', 'permission_slug' => 'view-system-settings', 'module' => 'System', 'description' => 'Can view system settings'],
            ['permission_name' => 'Edit System Settings', 'permission_slug' => 'edit-system-settings', 'module' => 'System', 'description' => 'Can edit system settings'],
            ['permission_name' => 'View Audit Logs', 'permission_slug' => 'view-audit-logs', 'module' => 'System', 'description' => 'Can view audit logs'],
            ['permission_name' => 'Manage Sync', 'permission_slug' => 'manage-sync', 'module' => 'System', 'description' => 'Can manage data synchronization'],
        ];

        foreach ($permissions as $permission) {
            $permission['created_at'] = date('Y-m-d H:i:s');
            $permission['updated_at'] = date('Y-m-d H:i:s');
        }

        $this->db->table('permissions')->insertBatch($permissions);
    }
}
