<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class RoleSeeder extends Seeder
{
    public function run()
    {
        // Define roles
        $roles = [
            [
                'role_name'   => 'Super Admin',
                'role_slug'   => 'super-admin',
                'description' => 'Full system access with all permissions',
                'is_active'   => 1,
            ],
            [
                'role_name'   => 'HR Manager',
                'role_slug'   => 'hr-manager',
                'description' => 'HR personnel with access to employee, attendance and leave management',
                'is_active'   => 1,
            ],
            [
                'role_name'   => 'Branch Manager',
                'role_slug'   => 'branch-manager',
                'description' => 'Location manager with access to location-specific data',
                'is_active'   => 1,
            ],
            [
                'role_name'   => 'Department Head',
                'role_slug'   => 'department-head',
                'description' => 'Department manager with limited access',
                'is_active'   => 1,
            ],
            [
                'role_name'   => 'Viewer',
                'role_slug'   => 'viewer',
                'description' => 'Read-only access to reports and dashboards',
                'is_active'   => 1,
            ],
        ];

        foreach ($roles as $role) {
            $role['created_at'] = date('Y-m-d H:i:s');
            $role['updated_at'] = date('Y-m-d H:i:s');
        }

        $this->db->table('roles')->insertBatch($roles);

        // Assign permissions to roles
        $this->assignPermissions();
    }

    private function assignPermissions()
    {
        // Get all permissions
        $allPermissions = $this->db->table('permissions')->select('id')->get()->getResultArray();
        $allPermissionIds = array_column($allPermissions, 'id');

        // Super Admin - all permissions
        $superAdminRole = $this->db->table('roles')->where('role_slug', 'super-admin')->get()->getRowArray();
        foreach ($allPermissionIds as $permissionId) {
            $this->db->table('role_permissions')->insert([
                'role_id'       => $superAdminRole['id'],
                'permission_id' => $permissionId,
                'created_at'    => date('Y-m-d H:i:s'),
            ]);
        }

        // HR Manager - most permissions except system settings
        $hrManagerRole = $this->db->table('roles')->where('role_slug', 'hr-manager')->get()->getRowArray();
        $hrPermissions = $this->db->table('permissions')
            ->whereNotIn('module', ['System'])
            ->orWhereIn('permission_slug', ['view-system-settings'])
            ->get()
            ->getResultArray();

        foreach ($hrPermissions as $permission) {
            $this->db->table('role_permissions')->insert([
                'role_id'       => $hrManagerRole['id'],
                'permission_id' => $permission['id'],
                'created_at'    => date('Y-m-d H:i:s'),
            ]);
        }

        // Branch Manager - attendance and leave for their location
        $branchManagerRole = $this->db->table('roles')->where('role_slug', 'branch-manager')->get()->getRowArray();
        $branchPermissions = $this->db->table('permissions')
            ->whereIn('permission_slug', [
                'view-dashboard', 'view-analytics', 'view-employees',
                'view-attendance', 'manual-attendance', 'edit-attendance',
                'approve-attendance-corrections', 'view-leave-requests',
                'approve-leave', 'generate-reports', 'export-reports'
            ])
            ->get()
            ->getResultArray();

        foreach ($branchPermissions as $permission) {
            $this->db->table('role_permissions')->insert([
                'role_id'       => $branchManagerRole['id'],
                'permission_id' => $permission['id'],
                'created_at'    => date('Y-m-d H:i:s'),
            ]);
        }

        // Viewer - read-only access
        $viewerRole = $this->db->table('roles')->where('role_slug', 'viewer')->get()->getRowArray();
        $viewerPermissions = $this->db->table('permissions')
            ->whereIn('permission_slug', [
                'view-dashboard', 'view-analytics', 'view-employees',
                'view-attendance', 'view-leave-requests', 'view-leave-balances',
                'generate-reports'
            ])
            ->get()
            ->getResultArray();

        foreach ($viewerPermissions as $permission) {
            $this->db->table('role_permissions')->insert([
                'role_id'       => $viewerRole['id'],
                'permission_id' => $permission['id'],
                'created_at'    => date('Y-m-d H:i:s'),
            ]);
        }
    }
}
