<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class SystemSettingSeeder extends Seeder
{
    public function run()
    {
        $settings = [
            // General Settings
            ['key' => 'app_name', 'value' => 'LBDI Attendance Management System', 'type' => 'string', 'description' => 'Application name', 'is_public' => 1],
            ['key' => 'app_timezone', 'value' => 'Asia/Manila', 'type' => 'string', 'description' => 'Default timezone', 'is_public' => 1],
            ['key' => 'date_format', 'value' => 'Y-m-d', 'type' => 'string', 'description' => 'Date format for display', 'is_public' => 1],
            ['key' => 'time_format', 'value' => 'H:i:s', 'type' => 'string', 'description' => 'Time format for display', 'is_public' => 1],

            // Attendance Settings
            ['key' => 'work_start_time', 'value' => '08:00:00', 'type' => 'string', 'description' => 'Default work start time', 'is_public' => 0],
            ['key' => 'work_end_time', 'value' => '17:00:00', 'type' => 'string', 'description' => 'Default work end time', 'is_public' => 0],
            ['key' => 'grace_period_minutes', 'value' => '15', 'type' => 'number', 'description' => 'Grace period for late arrival in minutes', 'is_public' => 0],
            ['key' => 'late_threshold_minutes', 'value' => '15', 'type' => 'number', 'description' => 'Minutes after which employee is marked late', 'is_public' => 0],
            ['key' => 'minimum_working_hours', 'value' => '8', 'type' => 'number', 'description' => 'Minimum daily working hours', 'is_public' => 0],
            ['key' => 'enable_facial_recognition', 'value' => '1', 'type' => 'boolean', 'description' => 'Enable facial recognition for sign-in', 'is_public' => 0],
            ['key' => 'enable_qr_code', 'value' => '1', 'type' => 'boolean', 'description' => 'Enable QR code scanning for sign-in', 'is_public' => 0],

            // Leave Settings
            ['key' => 'auto_approve_emergency_leave', 'value' => '0', 'type' => 'boolean', 'description' => 'Auto-approve emergency leave requests', 'is_public' => 0],
            ['key' => 'max_leave_carryforward', 'value' => '5', 'type' => 'number', 'description' => 'Maximum leave days that can be carried forward', 'is_public' => 0],
            ['key' => 'leave_approval_levels', 'value' => '1', 'type' => 'number', 'description' => 'Number of approval levels for leave requests', 'is_public' => 0],

            // Email Settings
            ['key' => 'smtp_host', 'value' => 'smtp.gmail.com', 'type' => 'string', 'description' => 'SMTP server host', 'is_public' => 0],
            ['key' => 'smtp_port', 'value' => '587', 'type' => 'number', 'description' => 'SMTP server port', 'is_public' => 0],
            ['key' => 'smtp_user', 'value' => 'noreply@lbdi.com', 'type' => 'string', 'description' => 'SMTP username', 'is_public' => 0],
            ['key' => 'email_from_name', 'value' => 'LBDI Attendance System', 'type' => 'string', 'description' => 'Email sender name', 'is_public' => 0],
            ['key' => 'enable_email_notifications', 'value' => '1', 'type' => 'boolean', 'description' => 'Enable email notifications', 'is_public' => 0],

            // Report Settings
            ['key' => 'report_logo', 'value' => '/assets/img/logo.png', 'type' => 'string', 'description' => 'Logo for reports', 'is_public' => 0],
            ['key' => 'report_footer', 'value' => 'LBDI Attendance Management System - Confidential', 'type' => 'string', 'description' => 'Footer text for reports', 'is_public' => 0],

            // Sync Settings
            ['key' => 'sync_interval_minutes', 'value' => '30', 'type' => 'number', 'description' => 'Data sync interval in minutes', 'is_public' => 0],
            ['key' => 'enable_auto_sync', 'value' => '1', 'type' => 'boolean', 'description' => 'Enable automatic data synchronization', 'is_public' => 0],
        ];

        foreach ($settings as &$setting) {
            $setting['created_at'] = date('Y-m-d H:i:s');
            $setting['updated_at'] = date('Y-m-d H:i:s');
        }

        $this->db->table('system_settings')->insertBatch($settings);
    }
}
