<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class UserSeeder extends Seeder
{
    public function run()
    {
        // Get role IDs
        $superAdminRole = $this->db->table('roles')->where('role_slug', 'super-admin')->get()->getRowArray();
        $hrManagerRole = $this->db->table('roles')->where('role_slug', 'hr-manager')->get()->getRowArray();
        $branchManagerRole = $this->db->table('roles')->where('role_slug', 'branch-manager')->get()->getRowArray();

        // Get location IDs
        $hqLocation = $this->db->table('locations')->where('location_code', 'LBDI-HQ')->get()->getRowArray();
        $cebuLocation = $this->db->table('locations')->where('location_code', 'LBDI-CEB')->get()->getRowArray();
        $davaoLocation = $this->db->table('locations')->where('location_code', 'LBDI-DAV')->get()->getRowArray();

        $users = [
            [
                'username'      => 'admin',
                'email'         => 'admin@lbdi.com',
                'password_hash' => password_hash('admin123', PASSWORD_BCRYPT),
                'first_name'    => 'System',
                'last_name'     => 'Administrator',
                'role_id'       => $superAdminRole['id'],
                'location_id'   => $hqLocation['id'],
                'phone'         => '+63-2-1234-5678',
                'is_active'     => 1,
            ],
            [
                'username'      => 'hrmanager',
                'email'         => 'hr.manager@lbdi.com',
                'password_hash' => password_hash('hr123456', PASSWORD_BCRYPT),
                'first_name'    => 'HR',
                'last_name'     => 'Manager',
                'role_id'       => $hrManagerRole['id'],
                'location_id'   => $hqLocation['id'],
                'phone'         => '+63-2-1234-5679',
                'is_active'     => 1,
            ],
            [
                'username'      => 'cebu.manager',
                'email'         => 'cebu.manager@lbdi.com',
                'password_hash' => password_hash('cebu123', PASSWORD_BCRYPT),
                'first_name'    => 'Maria',
                'last_name'     => 'Santos',
                'role_id'       => $branchManagerRole['id'],
                'location_id'   => $cebuLocation['id'],
                'phone'         => '+63-32-234-5678',
                'is_active'     => 1,
            ],
            [
                'username'      => 'davao.manager',
                'email'         => 'davao.manager@lbdi.com',
                'password_hash' => password_hash('davao123', PASSWORD_BCRYPT),
                'first_name'    => 'Pedro',
                'last_name'     => 'Reyes',
                'role_id'       => $branchManagerRole['id'],
                'location_id'   => $davaoLocation['id'],
                'phone'         => '+63-82-345-6789',
                'is_active'     => 1,
            ],
        ];

        foreach ($users as &$user) {
            $user['created_at'] = date('Y-m-d H:i:s');
            $user['updated_at'] = date('Y-m-d H:i:s');
        }

        $this->db->table('users')->insertBatch($users);
    }
}
