<?php

namespace App\Models;

use CodeIgniter\Model;

class DepartmentModel extends Model
{
    protected $table            = 'departments';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = [
        'name',
        'code',
        'description',
        'head_employee_id',
        'is_active'
    ];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules = [
        'code' => 'required|max_length[20]|is_unique[departments.code,id,{id}]',
        'name' => 'required|max_length[100]',
    ];

    protected $validationMessages = [
        'code' => [
            'required'  => 'Department code is required',
            'is_unique' => 'This department code already exists',
        ],
        'name' => [
            'required' => 'Department name is required',
        ],
    ];

    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    /**
     * Get active departments
     */
    public function getActiveDepartments()
    {
        return $this->where('is_active', 1)->findAll();
    }
}
