<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<!-- Header with Actions -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-user-edit me-2"></i><?= esc($pageTitle) ?></h2>
    <div>
        <a href="<?= base_url('attendance/today') ?>" class="btn btn-outline-secondary">
            <i class="fas fa-arrow-left"></i> Back to Today
        </a>
    </div>
</div>

<!-- Flash Messages -->
<?php if (session()->has('errors')): ?>
<div class="alert alert-danger alert-dismissible fade show" role="alert">
    <strong>Please fix the following errors:</strong>
    <ul class="mb-0 mt-2">
        <?php foreach (session('errors') as $error): ?>
        <li><?= esc($error) ?></li>
        <?php endforeach; ?>
    </ul>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<?php if (session()->has('error')): ?>
<div class="alert alert-danger alert-dismissible fade show" role="alert">
    <i class="fas fa-exclamation-circle me-2"></i><?= session('error') ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<!-- Manual Entry Form -->
<form action="<?= base_url('attendance/manual-entry/save') ?>" method="post" id="manualEntryForm">
    <?= csrf_field() ?>

    <div class="row">
        <!-- Form Fields -->
        <div class="col-md-8">
            <!-- Basic Information -->
            <div class="table-card mb-4">
                <h5 class="mb-3"><i class="fas fa-info-circle me-2"></i>Basic Information</h5>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="employee_id" class="form-label">Employee <span class="text-danger">*</span></label>
                        <select class="form-select" id="employee_id" name="employee_id" required>
                            <option value="">Select Employee</option>
                            <?php foreach ($employees as $employee): ?>
                            <option value="<?= $employee['employee_id'] ?>"
                                    data-location="<?= $employee['location_id'] ?>"
                                    <?= old('employee_id') == $employee['employee_id'] ? 'selected' : '' ?>>
                                <?= esc($employee['employee_number'] . ' - ' . $employee['first_name'] . ' ' . $employee['last_name']) ?>
                            </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="attendance_date" class="form-label">Date <span class="text-danger">*</span></label>
                        <input type="date" class="form-control" id="attendance_date" name="attendance_date"
                               value="<?= old('attendance_date', date('Y-m-d')) ?>" required max="<?= date('Y-m-d') ?>">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="location_id" class="form-label">Location <span class="text-danger">*</span></label>
                        <select class="form-select" id="location_id" name="location_id" required>
                            <option value="">Select Location</option>
                            <?php foreach ($locations as $location): ?>
                            <option value="<?= $location['id'] ?>" <?= old('location_id') == $location['id'] ? 'selected' : '' ?>>
                                <?= esc($location['name']) ?>
                            </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
                        <select class="form-select" id="status" name="status" required>
                            <option value="Present" <?= old('status') == 'Present' ? 'selected' : '' ?>>Present</option>
                            <option value="Late" <?= old('status') == 'Late' ? 'selected' : '' ?>>Late</option>
                            <option value="Absent" <?= old('status') == 'Absent' ? 'selected' : '' ?>>Absent</option>
                            <option value="On Leave" <?= old('status') == 'On Leave' ? 'selected' : '' ?>>On Leave</option>
                            <option value="Half Day" <?= old('status') == 'Half Day' ? 'selected' : '' ?>>Half Day</option>
                            <option value="Work From Home" <?= old('status') == 'Work From Home' ? 'selected' : '' ?>>Work From Home</option>
                        </select>
                    </div>
                </div>
            </div>

            <!-- Time Information -->
            <div class="table-card mb-4">
                <h5 class="mb-3"><i class="fas fa-clock me-2"></i>Time Information</h5>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="sign_in_time" class="form-label">Sign In Time <span class="text-danger">*</span></label>
                        <input type="time" class="form-control" id="sign_in_time" name="sign_in_time"
                               value="<?= old('sign_in_time') ?>" required>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="sign_out_time" class="form-label">Sign Out Time</label>
                        <input type="time" class="form-control" id="sign_out_time" name="sign_out_time"
                               value="<?= old('sign_out_time') ?>">
                        <small class="text-muted">Leave empty if employee hasn't signed out yet</small>
                    </div>

                    <div class="col-md-6 mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="is_late" name="is_late" value="1"
                                   <?= old('is_late') ? 'checked' : '' ?>>
                            <label class="form-check-label" for="is_late">
                                Mark as Late
                            </label>
                        </div>
                    </div>

                    <div class="col-md-6 mb-3" id="late_minutes_container" style="display: none;">
                        <label for="late_minutes" class="form-label">Late Minutes</label>
                        <input type="number" class="form-control" id="late_minutes" name="late_minutes"
                               value="<?= old('late_minutes', 0) ?>" min="0">
                    </div>

                    <div class="col-md-12 mb-3">
                        <label for="notes" class="form-label">Notes</label>
                        <textarea class="form-control" id="notes" name="notes" rows="3"><?= old('notes') ?></textarea>
                        <small class="text-muted">Add any additional notes or reasons for manual entry</small>
                    </div>
                </div>
            </div>

            <!-- Form Actions -->
            <div class="d-flex justify-content-end gap-2">
                <a href="<?= base_url('attendance/today') ?>" class="btn btn-secondary">
                    <i class="fas fa-times"></i> Cancel
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Save Attendance
                </button>
            </div>
        </div>

        <!-- Help Panel -->
        <div class="col-md-4">
            <div class="table-card">
                <h5 class="mb-3"><i class="fas fa-question-circle me-2"></i>Manual Entry Guidelines</h5>

                <div class="mb-3">
                    <h6 class="text-primary">When to use Manual Entry:</h6>
                    <ul class="small">
                        <li>Employee forgot to sign in/out</li>
                        <li>System was down during sign in/out time</li>
                        <li>Employee was on field duty</li>
                        <li>Correcting attendance errors</li>
                    </ul>
                </div>

                <div class="mb-3">
                    <h6 class="text-primary">Status Meanings:</h6>
                    <ul class="small mb-0">
                        <li><strong>Present:</strong> Employee was present on time</li>
                        <li><strong>Late:</strong> Employee arrived late</li>
                        <li><strong>Absent:</strong> Employee did not show up</li>
                        <li><strong>On Leave:</strong> Employee on approved leave</li>
                        <li><strong>Half Day:</strong> Employee worked half day</li>
                        <li><strong>Work From Home:</strong> Remote work</li>
                    </ul>
                </div>

                <div class="alert alert-warning small mb-0">
                    <i class="fas fa-exclamation-triangle"></i>
                    <strong>Important:</strong> All manual entries are tracked and audited. Please provide accurate information and add notes explaining the reason for manual entry.
                </div>
            </div>
        </div>
    </div>
</form>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
// Auto-fill location when employee is selected
document.getElementById('employee_id').addEventListener('change', function() {
    const selectedOption = this.options[this.selectedIndex];
    const locationId = selectedOption.getAttribute('data-location');

    if (locationId) {
        document.getElementById('location_id').value = locationId;
    }
});

// Show/hide late minutes field
document.getElementById('is_late').addEventListener('change', function() {
    const lateMinutesContainer = document.getElementById('late_minutes_container');
    if (this.checked) {
        lateMinutesContainer.style.display = 'block';
    } else {
        lateMinutesContainer.style.display = 'none';
        document.getElementById('late_minutes').value = 0;
    }
});

// Auto-check late if status is Late
document.getElementById('status').addEventListener('change', function() {
    const isLateCheckbox = document.getElementById('is_late');
    if (this.value === 'Late') {
        isLateCheckbox.checked = true;
        document.getElementById('late_minutes_container').style.display = 'block';
    }
});

// Initialize on page load
if (document.getElementById('is_late').checked) {
    document.getElementById('late_minutes_container').style.display = 'block';
}

// Validate sign out time is after sign in time
document.getElementById('manualEntryForm').addEventListener('submit', function(e) {
    const signInTime = document.getElementById('sign_in_time').value;
    const signOutTime = document.getElementById('sign_out_time').value;

    if (signInTime && signOutTime) {
        const signIn = new Date('2000-01-01 ' + signInTime);
        const signOut = new Date('2000-01-01 ' + signOutTime);

        if (signOut <= signIn) {
            e.preventDefault();
            alert('Sign out time must be after sign in time');
            return false;
        }
    }
});
</script>
<?= $this->endSection() ?>
