<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<!-- Header with Actions -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-clipboard-check me-2"></i><?= esc($pageTitle) ?></h2>
    <div>
        <a href="<?= base_url('attendance') ?>" class="btn btn-outline-secondary">
            <i class="fas fa-arrow-left"></i> Back to List
        </a>
    </div>
</div>

<div class="row">
    <!-- Employee Information -->
    <div class="col-md-4 mb-4">
        <div class="table-card text-center">
            <?php if (!empty($attendance['photo'])): ?>
            <img src="<?= base_url('uploads/employees/' . $attendance['photo']) ?>"
                 alt="<?= esc($attendance['first_name']) ?>"
                 class="rounded-circle mb-3"
                 style="width: 120px; height: 120px; object-fit: cover;">
            <?php else: ?>
            <div class="rounded-circle bg-secondary text-white d-inline-flex align-items-center justify-content-center mb-3"
                 style="width: 120px; height: 120px; font-size: 48px;">
                <i class="fas fa-user"></i>
            </div>
            <?php endif; ?>

            <h4><?= esc($attendance['first_name'] . ' ' . $attendance['last_name']) ?></h4>
            <p class="text-muted mb-1"><?= esc($attendance['position'] ?? 'N/A') ?></p>
            <p class="text-muted mb-3"><?= esc($attendance['employee_number']) ?></p>

            <div class="mb-3">
                <?php
                $statusColors = [
                    'Present' => 'success',
                    'Late' => 'warning',
                    'Absent' => 'danger',
                    'On Leave' => 'info',
                    'Half Day' => 'secondary',
                    'Work From Home' => 'primary'
                ];
                $statusColor = $statusColors[$attendance['status']] ?? 'secondary';
                ?>
                <span class="badge bg-<?= $statusColor ?> fs-6">
                    <?= esc($attendance['status']) ?>
                </span>
            </div>

            <?php if ($attendance['is_late']): ?>
            <div class="alert alert-warning mb-0">
                <i class="fas fa-clock"></i>
                <strong>Late Arrival</strong><br>
                <?= $attendance['late_minutes'] ?> minutes late
            </div>
            <?php endif; ?>
        </div>

        <!-- Quick Info Card -->
        <div class="table-card mt-3">
            <h5 class="mb-3"><i class="fas fa-info-circle me-2"></i>Quick Info</h5>
            <div class="d-flex justify-content-between mb-2">
                <span>Department</span>
                <strong><?= esc($attendance['department_name'] ?? 'N/A') ?></strong>
            </div>
            <div class="d-flex justify-content-between mb-2">
                <span>Location</span>
                <strong><?= esc($attendance['location_name']) ?></strong>
            </div>
            <div class="d-flex justify-content-between">
                <span>Date</span>
                <strong><?= date('M d, Y', strtotime($attendance['attendance_date'])) ?></strong>
            </div>
        </div>
    </div>

    <!-- Attendance Details -->
    <div class="col-md-8">
        <!-- Time Information -->
        <div class="table-card mb-4">
            <h5 class="mb-3"><i class="fas fa-clock me-2"></i>Time Information</h5>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <div class="p-3 bg-light rounded">
                        <div class="d-flex align-items-center mb-2">
                            <div class="icon-circle me-3" style="width: 50px; height: 50px; border-radius: 50%; background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%); display: flex; align-items-center; justify-content: center; color: white;">
                                <i class="fas fa-sign-in-alt fa-lg"></i>
                            </div>
                            <div>
                                <small class="text-muted">Sign In Time</small>
                                <h5 class="mb-0">
                                    <?php if ($attendance['sign_in_time']): ?>
                                    <?= date('h:i A', strtotime($attendance['sign_in_time'])) ?>
                                    <?php else: ?>
                                    <span class="text-muted">Not recorded</span>
                                    <?php endif; ?>
                                </h5>
                            </div>
                        </div>
                        <small class="text-muted">
                            <i class="fas fa-qrcode"></i> <?= esc($attendance['sign_in_method'] ?? 'Manual') ?>
                        </small>
                    </div>
                </div>

                <div class="col-md-6 mb-3">
                    <div class="p-3 bg-light rounded">
                        <div class="d-flex align-items-center mb-2">
                            <div class="icon-circle me-3" style="width: 50px; height: 50px; border-radius: 50%; background: linear-gradient(135deg, #ee0979 0%, #ff6a00 100%); display: flex; align-items-center; justify-content: center; color: white;">
                                <i class="fas fa-sign-out-alt fa-lg"></i>
                            </div>
                            <div>
                                <small class="text-muted">Sign Out Time</small>
                                <h5 class="mb-0">
                                    <?php if ($attendance['sign_out_time']): ?>
                                    <?= date('h:i A', strtotime($attendance['sign_out_time'])) ?>
                                    <?php else: ?>
                                    <span class="badge bg-info">Active</span>
                                    <?php endif; ?>
                                </h5>
                            </div>
                        </div>
                        <?php if ($attendance['sign_out_time']): ?>
                        <small class="text-muted">
                            <i class="fas fa-qrcode"></i> <?= esc($attendance['sign_out_method'] ?? 'Manual') ?>
                        </small>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="col-md-6 mb-3">
                    <label class="text-muted small">Working Hours</label>
                    <h4 class="mb-0">
                        <?php if ($attendance['working_hours']): ?>
                        <?= number_format($attendance['working_hours'], 2) ?> hours
                        <?php else: ?>
                        <?php if ($attendance['sign_in_time']): ?>
                        <?php
                        $signIn = strtotime($attendance['sign_in_time']);
                        $duration = (time() - $signIn) / 3600;
                        ?>
                        <span class="text-muted"><?= number_format($duration, 2) ?> hours (ongoing)</span>
                        <?php else: ?>
                        <span class="text-muted">-</span>
                        <?php endif; ?>
                        <?php endif; ?>
                    </h4>
                </div>

                <div class="col-md-6 mb-3">
                    <label class="text-muted small">Overtime Hours</label>
                    <h4 class="mb-0">
                        <?= $attendance['overtime_hours'] ? number_format($attendance['overtime_hours'], 2) . ' hours' : '-' ?>
                    </h4>
                </div>
            </div>
        </div>

        <!-- Additional Information -->
        <div class="table-card mb-4">
            <h5 class="mb-3"><i class="fas fa-file-alt me-2"></i>Additional Information</h5>
            <div class="row">
                <div class="col-md-12 mb-3">
                    <label class="text-muted small">Notes</label>
                    <p class="mb-0">
                        <?= $attendance['notes'] ? esc($attendance['notes']) : '<span class="text-muted">No notes recorded</span>' ?>
                    </p>
                </div>

                <?php if (!empty($attendance['sign_in_device_id']) || !empty($attendance['sign_out_device_id'])): ?>
                <div class="col-md-6 mb-3">
                    <label class="text-muted small">Sign In Device</label>
                    <p class="mb-0">
                        <code><?= esc($attendance['sign_in_device_id'] ?? 'N/A') ?></code>
                    </p>
                </div>

                <div class="col-md-6 mb-3">
                    <label class="text-muted small">Sign Out Device</label>
                    <p class="mb-0">
                        <code><?= esc($attendance['sign_out_device_id'] ?? 'N/A') ?></code>
                    </p>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- System Information -->
        <div class="table-card">
            <h5 class="mb-3"><i class="fas fa-cog me-2"></i>System Information</h5>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="text-muted small">Record Created</label>
                    <p class="mb-0"><?= date('M d, Y h:i A', strtotime($attendance['created_at'])) ?></p>
                </div>

                <div class="col-md-6 mb-3">
                    <label class="text-muted small">Last Updated</label>
                    <p class="mb-0"><?= date('M d, Y h:i A', strtotime($attendance['updated_at'])) ?></p>
                </div>

                <?php if (!empty($attendance['created_by'])): ?>
                <div class="col-md-6 mb-3">
                    <label class="text-muted small">Created By</label>
                    <p class="mb-0">
                        <span class="badge bg-info">User ID: <?= $attendance['created_by'] ?></span>
                    </p>
                </div>
                <?php endif; ?>

                <?php if (!empty($attendance['sync_status'])): ?>
                <div class="col-md-6 mb-3">
                    <label class="text-muted small">Sync Status</label>
                    <p class="mb-0">
                        <span class="badge bg-<?= $attendance['sync_status'] == 'Synced' ? 'success' : 'warning' ?>">
                            <?= esc($attendance['sync_status']) ?>
                        </span>
                    </p>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>
