<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<!-- Header with Actions -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-file-import me-2"></i><?= esc($pageTitle) ?></h2>
    <a href="<?= base_url('employees') ?>" class="btn btn-outline-secondary">
        <i class="fas fa-arrow-left"></i> Back to List
    </a>
</div>

<!-- Flash Messages -->
<?php if (session()->has('success')): ?>
<div class="alert alert-success alert-dismissible fade show" role="alert">
    <i class="fas fa-check-circle me-2"></i><?= session('success') ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<?php if (session()->has('error')): ?>
<div class="alert alert-danger alert-dismissible fade show" role="alert">
    <i class="fas fa-exclamation-circle me-2"></i><?= session('error') ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<?php if (session()->has('import_errors')): ?>
<div class="alert alert-warning alert-dismissible fade show" role="alert">
    <strong>Import Errors:</strong>
    <ul class="mb-0 mt-2">
        <?php foreach (session('import_errors') as $error): ?>
        <li>Row <?= $error['row'] ?>: <?= is_array($error['errors'] ?? null) ? implode(', ', $error['errors']) : ($error['message'] ?? 'Unknown error') ?></li>
        <?php endforeach; ?>
    </ul>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<div class="row">
    <!-- Import Instructions -->
    <div class="col-md-6">
        <div class="table-card">
            <h5 class="mb-3"><i class="fas fa-info-circle me-2"></i>Import Instructions</h5>

            <ol class="mb-3">
                <li class="mb-2">Download the CSV template below</li>
                <li class="mb-2">Fill in employee data following the template format</li>
                <li class="mb-2">Save the file as CSV format</li>
                <li class="mb-2">Upload the file using the form on the right</li>
            </ol>

            <div class="alert alert-info mb-3">
                <strong>Required Fields:</strong>
                <ul class="mb-0 mt-2">
                    <li>employee_number</li>
                    <li>first_name</li>
                    <li>last_name</li>
                    <li>location_id</li>
                    <li>hire_date (Format: YYYY-MM-DD)</li>
                </ul>
            </div>

            <button type="button" class="btn btn-primary w-100" onclick="downloadTemplate()">
                <i class="fas fa-download"></i> Download CSV Template
            </button>
        </div>

        <!-- CSV Format Example -->
        <div class="table-card mt-3">
            <h5 class="mb-3"><i class="fas fa-table me-2"></i>CSV Format Example</h5>
            <div class="table-responsive">
                <table class="table table-sm table-bordered">
                    <thead class="table-light">
                        <tr>
                            <th>employee_number</th>
                            <th>first_name</th>
                            <th>last_name</th>
                            <th>email</th>
                            <th>location_id</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>EMP001</td>
                            <td>John</td>
                            <td>Doe</td>
                            <td>john@example.com</td>
                            <td>1</td>
                        </tr>
                        <tr>
                            <td>EMP002</td>
                            <td>Jane</td>
                            <td>Smith</td>
                            <td>jane@example.com</td>
                            <td>1</td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <small class="text-muted">This is a simplified example. Download the template for all available fields.</small>
        </div>
    </div>

    <!-- Upload Form -->
    <div class="col-md-6">
        <div class="table-card">
            <h5 class="mb-3"><i class="fas fa-upload me-2"></i>Upload CSV File</h5>

            <form action="<?= base_url('employees/import/process') ?>" method="post" enctype="multipart/form-data" id="importForm">
                <?= csrf_field() ?>

                <div class="mb-4">
                    <label for="csv_file" class="form-label">Select CSV File <span class="text-danger">*</span></label>
                    <input type="file" class="form-control" id="csv_file" name="csv_file" accept=".csv" required>
                    <small class="text-muted">Only CSV files are allowed</small>
                </div>

                <div class="alert alert-warning">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    <strong>Warning:</strong> Please ensure your CSV file is properly formatted. Invalid data may cause import errors.
                </div>

                <div class="d-grid gap-2">
                    <button type="submit" class="btn btn-primary btn-lg">
                        <i class="fas fa-file-import"></i> Import Employees
                    </button>
                    <a href="<?= base_url('employees') ?>" class="btn btn-outline-secondary">
                        <i class="fas fa-times"></i> Cancel
                    </a>
                </div>
            </form>
        </div>

        <!-- Import Tips -->
        <div class="table-card mt-3">
            <h5 class="mb-3"><i class="fas fa-lightbulb me-2"></i>Import Tips</h5>
            <ul class="mb-0">
                <li class="mb-2">Employee numbers must be unique</li>
                <li class="mb-2">Email addresses must be valid and unique (if provided)</li>
                <li class="mb-2">Location ID must exist in the system</li>
                <li class="mb-2">Department ID must exist in the system (if provided)</li>
                <li class="mb-2">Date fields should be in YYYY-MM-DD format</li>
                <li class="mb-2">Employment status: full-time, part-time, or contract</li>
                <li class="mb-2">Status: active or inactive</li>
                <li class="mb-2">Gender: male, female, or other</li>
            </ul>
        </div>
    </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
// Download CSV template
function downloadTemplate() {
    const headers = [
        'employee_number',
        'first_name',
        'middle_name',
        'last_name',
        'email',
        'phone',
        'date_of_birth',
        'gender',
        'address',
        'city',
        'province',
        'zip_code',
        'location_id',
        'department_id',
        'position',
        'employment_status',
        'hire_date',
        'status'
    ];

    // Sample data row
    const sampleData = [
        'EMP001',
        'John',
        'M',
        'Doe',
        'john.doe@example.com',
        '555-1234',
        '1990-01-15',
        'male',
        '123 Main St',
        'Manila',
        'Metro Manila',
        '1000',
        '1',
        '1',
        'Software Developer',
        'full-time',
        '2024-01-01',
        'active'
    ];

    // Create CSV content
    let csvContent = headers.join(',') + '\n';
    csvContent += sampleData.join(',') + '\n';

    // Create download link
    const blob = new Blob([csvContent], { type: 'text/csv' });
    const url = window.URL.createObjectURL(blob);
    const a = document.createElement('a');
    a.setAttribute('hidden', '');
    a.setAttribute('href', url);
    a.setAttribute('download', 'employee_import_template.csv');
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
}

// File validation
document.getElementById('csv_file').addEventListener('change', function(e) {
    const file = e.target.files[0];
    if (file) {
        const fileName = file.name;
        const fileExtension = fileName.split('.').pop().toLowerCase();

        if (fileExtension !== 'csv') {
            alert('Please select a CSV file');
            this.value = '';
            return;
        }

        // Check file size (max 5MB)
        const maxSize = 5 * 1024 * 1024; // 5MB
        if (file.size > maxSize) {
            alert('File size must not exceed 5MB');
            this.value = '';
            return;
        }
    }
});

// Form submission confirmation
document.getElementById('importForm').addEventListener('submit', function(e) {
    const file = document.getElementById('csv_file').files[0];
    if (!file) {
        e.preventDefault();
        alert('Please select a CSV file to upload');
        return false;
    }

    if (!confirm('Are you sure you want to import employees from this file?')) {
        e.preventDefault();
        return false;
    }
});
</script>
<?= $this->endSection() ?>
