<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<!-- Header with Actions -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-user me-2"></i><?= esc($pageTitle) ?></h2>
    <div>
        <a href="<?= base_url('employees') ?>" class="btn btn-outline-secondary me-2">
            <i class="fas fa-arrow-left"></i> Back to List
        </a>

        <?php if (has_permission('edit-employee')): ?>
        <a href="<?= base_url('employees/edit/' . $employee['employee_id']) ?>" class="btn btn-primary">
            <i class="fas fa-edit"></i> Edit Employee
        </a>
        <?php endif; ?>

        <?php if (has_permission('create-user')): ?>
        <button type="button" class="btn btn-success" id="convertToUserBtn" onclick="checkAndConvertToUser(<?= $employee['employee_id'] ?>)">
            <i class="fas fa-user-plus"></i> Create User Account
        </button>
        <?php endif; ?>
    </div>
</div>

<div class="row">
    <!-- Employee Profile Card -->
    <div class="col-md-4 mb-4">
        <div class="table-card text-center">
            <?php if (!empty($employee['photo'])): ?>
            <img src="<?= base_url('uploads/employees/' . $employee['photo']) ?>"
                 alt="<?= esc($employee['first_name']) ?>"
                 class="rounded-circle mb-3"
                 style="width: 150px; height: 150px; object-fit: cover;">
            <?php else: ?>
            <div class="rounded-circle bg-secondary text-white d-inline-flex align-items-center justify-content-center mb-3"
                 style="width: 150px; height: 150px; font-size: 60px;">
                <i class="fas fa-user"></i>
            </div>
            <?php endif; ?>

            <h4><?= esc($employee['first_name'] . ' ' . $employee['last_name']) ?></h4>
            <p class="text-muted mb-3"><?= esc($employee['position'] ?? 'N/A') ?></p>

            <div class="mb-3">
                <span class="badge bg-<?= $employee['status'] == 'active' ? 'success' : 'danger' ?> fs-6">
                    <?= esc(ucfirst($employee['status'])) ?>
                </span>
            </div>

            <?php if (!empty($employee['qr_code'])): ?>
            <div class="p-3 bg-light rounded text-center">
                <h6 class="text-muted mb-3">QR Code</h6>
                <!-- QR Code Image -->
                <div class="mb-3">
                    <img src="https://api.qrserver.com/v1/create-qr-code/?size=200x200&data=<?= urlencode($employee['qr_code']) ?>"
                         alt="QR Code"
                         class="img-fluid"
                         style="max-width: 200px; border: 5px solid white; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                </div>
                <h5 class="mb-2"><?= esc($employee['qr_code']) ?></h5>
                <button type="button" class="btn btn-sm btn-outline-primary" onclick="downloadQRCode('<?= esc($employee['qr_code']) ?>', '<?= esc($employee['first_name'] . '_' . $employee['last_name']) ?>')">
                    <i class="fas fa-download"></i> Download QR
                </button>
                <button type="button" class="btn btn-sm btn-outline-secondary" onclick="printQRCode('<?= esc($employee['qr_code']) ?>', '<?= esc($employee['first_name'] . ' ' . $employee['last_name']) ?>', '<?= esc($employee['employee_number']) ?>')">
                    <i class="fas fa-print"></i> Print QR
                </button>
            </div>
            <?php endif; ?>
        </div>

        <!-- Quick Stats Card -->
        <div class="table-card mt-3">
            <h5 class="mb-3"><i class="fas fa-chart-bar me-2"></i>Quick Stats</h5>
            <div class="d-flex justify-content-between mb-2">
                <span>Employee #</span>
                <strong><?= esc($employee['employee_number']) ?></strong>
            </div>
            <div class="d-flex justify-content-between mb-2">
                <span>Employment Type</span>
                <strong><?= esc(ucwords(str_replace('-', ' ', $employee['employment_status'] ?? 'N/A'))) ?></strong>
            </div>
            <div class="d-flex justify-content-between mb-2">
                <span>Hire Date</span>
                <strong><?= !empty($employee['hire_date']) ? date('M d, Y', strtotime($employee['hire_date'])) : 'N/A' ?></strong>
            </div>
        </div>
    </div>

    <!-- Employee Details -->
    <div class="col-md-8">
        <!-- Personal Information -->
        <div class="table-card mb-4">
            <h5 class="mb-3"><i class="fas fa-id-card me-2"></i>Personal Information</h5>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="text-muted small">First Name</label>
                    <p class="mb-0"><?= esc($employee['first_name']) ?></p>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="text-muted small">Middle Name</label>
                    <p class="mb-0"><?= esc($employee['middle_name'] ?? '-') ?></p>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="text-muted small">Last Name</label>
                    <p class="mb-0"><?= esc($employee['last_name']) ?></p>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="text-muted small">Email Address</label>
                    <p class="mb-0">
                        <?php if (!empty($employee['email'])): ?>
                        <a href="mailto:<?= esc($employee['email']) ?>"><?= esc($employee['email']) ?></a>
                        <?php else: ?>
                        -
                        <?php endif; ?>
                    </p>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="text-muted small">Phone Number</label>
                    <p class="mb-0"><?= esc($employee['phone'] ?? '-') ?></p>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="text-muted small">Date of Birth</label>
                    <p class="mb-0"><?= !empty($employee['date_of_birth']) ? date('M d, Y', strtotime($employee['date_of_birth'])) : '-' ?></p>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="text-muted small">Gender</label>
                    <p class="mb-0"><?= esc(ucfirst($employee['gender'] ?? '-')) ?></p>
                </div>
            </div>
        </div>

        <!-- Address Information -->
        <div class="table-card mb-4">
            <h5 class="mb-3"><i class="fas fa-map-marker-alt me-2"></i>Address Information</h5>
            <div class="row">
                <div class="col-md-12 mb-3">
                    <label class="text-muted small">Street Address</label>
                    <p class="mb-0"><?= esc($employee['address'] ?? '-') ?></p>
                </div>
                <div class="col-md-4 mb-3">
                    <label class="text-muted small">City</label>
                    <p class="mb-0"><?= esc($employee['city'] ?? '-') ?></p>
                </div>
                <div class="col-md-4 mb-3">
                    <label class="text-muted small">Province</label>
                    <p class="mb-0"><?= esc($employee['province'] ?? '-') ?></p>
                </div>
                <div class="col-md-4 mb-3">
                    <label class="text-muted small">Zip Code</label>
                    <p class="mb-0"><?= esc($employee['zip_code'] ?? '-') ?></p>
                </div>
            </div>
        </div>

        <!-- Employment Information -->
        <div class="table-card">
            <h5 class="mb-3"><i class="fas fa-briefcase me-2"></i>Employment Information</h5>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="text-muted small">Employee Number</label>
                    <p class="mb-0"><strong><?= esc($employee['employee_number']) ?></strong></p>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="text-muted small">Position</label>
                    <p class="mb-0"><?= esc($employee['position'] ?? '-') ?></p>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="text-muted small">Department</label>
                    <p class="mb-0"><?= esc($employee['department_name'] ?? '-') ?></p>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="text-muted small">Location</label>
                    <p class="mb-0"><?= esc($employee['location_name'] ?? '-') ?></p>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="text-muted small">Employment Status</label>
                    <p class="mb-0">
                        <span class="badge bg-<?= $employee['employment_status'] == 'full-time' ? 'primary' : ($employee['employment_status'] == 'part-time' ? 'info' : 'secondary') ?>">
                            <?= esc(ucwords(str_replace('-', ' ', $employee['employment_status'] ?? 'N/A'))) ?>
                        </span>
                    </p>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="text-muted small">Hire Date</label>
                    <p class="mb-0"><?= !empty($employee['hire_date']) ? date('M d, Y', strtotime($employee['hire_date'])) : '-' ?></p>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="text-muted small">Account Status</label>
                    <p class="mb-0">
                        <span class="badge bg-<?= $employee['status'] == 'active' ? 'success' : 'danger' ?>">
                            <?= esc(ucfirst($employee['status'])) ?>
                        </span>
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Convert to User Modal -->
<div class="modal fade" id="convertToUserModal" tabindex="-1" aria-labelledby="convertToUserModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="convertToUserModalLabel">
                    <i class="fas fa-user-plus me-2"></i>Create User Account
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="convertToUserForm">
                <?= csrf_field() ?>
                <div class="modal-body">
                    <input type="hidden" id="employee_id" name="employee_id" value="<?= $employee['employee_id'] ?>">

                    <div class="alert alert-info">
                        <i class="fas fa-info-circle me-2"></i>
                        This will create a login account for <strong><?= esc($employee['first_name'] . ' ' . $employee['last_name']) ?></strong>
                    </div>

                    <div class="mb-3">
                        <label for="username" class="form-label">Username <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="username" name="username" required>
                        <small class="form-text text-muted">This will be used to log in to the system</small>
                    </div>

                    <div class="mb-3">
                        <label for="password" class="form-label">Password <span class="text-danger">*</span></label>
                        <input type="password" class="form-control" id="password" name="password" required minlength="6">
                        <small class="form-text text-muted">Minimum 6 characters</small>
                    </div>

                    <div class="mb-3">
                        <label for="password_confirm" class="form-label">Confirm Password <span class="text-danger">*</span></label>
                        <input type="password" class="form-control" id="password_confirm" name="password_confirm" required>
                    </div>

                    <div class="mb-3">
                        <label for="role_id" class="form-label">Role <span class="text-danger">*</span></label>
                        <select class="form-control" id="role_id" name="role_id" required>
                            <option value="">Select a role...</option>
                        </select>
                        <small class="form-text text-muted">This determines what the user can access in the system</small>
                    </div>

                    <div id="errorMessages" class="alert alert-danger d-none"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-user-plus me-2"></i>Create User Account
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
// Download QR Code
function downloadQRCode(qrCode, employeeName) {
    const qrUrl = `https://api.qrserver.com/v1/create-qr-code/?size=400x400&data=${encodeURIComponent(qrCode)}`;
    const fileName = `QR_${employeeName}.png`;

    fetch(qrUrl)
        .then(response => response.blob())
        .then(blob => {
            const url = window.URL.createObjectURL(blob);
            const a = document.createElement('a');
            a.style.display = 'none';
            a.href = url;
            a.download = fileName;
            document.body.appendChild(a);
            a.click();
            window.URL.revokeObjectURL(url);
            document.body.removeChild(a);
        })
        .catch(error => {
            console.error('Error downloading QR code:', error);
            alert('Failed to download QR code');
        });
}

// Print QR Code
function printQRCode(qrCode, employeeName, employeeNumber) {
    const qrUrl = `https://api.qrserver.com/v1/create-qr-code/?size=400x400&data=${encodeURIComponent(qrCode)}`;

    const printWindow = window.open('', '_blank');
    printWindow.document.write(`
        <!DOCTYPE html>
        <html>
        <head>
            <title>Print QR Code - ${employeeName}</title>
            <style>
                @media print {
                    @page {
                        margin: 20mm;
                    }
                }
                body {
                    font-family: Arial, sans-serif;
                    display: flex;
                    justify-content: center;
                    align-items: center;
                    min-height: 100vh;
                    margin: 0;
                    padding: 20px;
                }
                .qr-container {
                    text-align: center;
                    border: 2px solid #333;
                    padding: 30px;
                    max-width: 500px;
                }
                .qr-image {
                    max-width: 100%;
                    height: auto;
                    margin: 20px 0;
                }
                h1 {
                    margin: 0 0 10px 0;
                    font-size: 24px;
                }
                .employee-info {
                    margin: 10px 0;
                    font-size: 16px;
                }
                .qr-code-text {
                    margin: 20px 0 10px 0;
                    font-size: 20px;
                    font-weight: bold;
                    font-family: monospace;
                }
                .instructions {
                    margin-top: 20px;
                    font-size: 14px;
                    color: #666;
                }
            </style>
        </head>
        <body>
            <div class="qr-container">
                <h1>Employee QR Code</h1>
                <div class="employee-info">
                    <strong>${employeeName}</strong><br>
                    Employee #: ${employeeNumber}
                </div>
                <img src="${qrUrl}" alt="QR Code" class="qr-image">
                <div class="qr-code-text">${qrCode}</div>
                <div class="instructions">
                    Scan this QR code for attendance tracking
                </div>
            </div>
        </body>
        </html>
    `);

    printWindow.document.close();

    // Wait for image to load before printing
    printWindow.onload = function() {
        setTimeout(function() {
            printWindow.print();
        }, 500);
    };
}

// Check if employee already has user account and show modal
function checkAndConvertToUser(employeeId) {
    // First check if employee already has a user account
    fetch(`<?= base_url('employees/check-user-account/') ?>${employeeId}`)
        .then(response => response.json())
        .then(data => {
            if (data.has_account) {
                alert('This employee already has a user account.');
                return;
            }

            // Load roles and suggested username
            fetch(`<?= base_url('employees/convert-to-user/') ?>${employeeId}`)
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        // Populate roles dropdown
                        const roleSelect = document.getElementById('role_id');
                        roleSelect.innerHTML = '<option value="">Select a role...</option>';
                        data.roles.forEach(role => {
                            const option = document.createElement('option');
                            option.value = role.id;
                            option.textContent = role.name;
                            roleSelect.appendChild(option);
                        });

                        // Set suggested username
                        document.getElementById('username').value = data.suggested_username;

                        // Show modal
                        const modal = new bootstrap.Modal(document.getElementById('convertToUserModal'));
                        modal.show();
                    } else {
                        alert(data.message || 'Failed to load user creation form');
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('An error occurred while loading the form');
                });
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred while checking user account');
        });
}

// Handle form submission
document.getElementById('convertToUserForm').addEventListener('submit', function(e) {
    e.preventDefault();

    const password = document.getElementById('password').value;
    const passwordConfirm = document.getElementById('password_confirm').value;
    const errorDiv = document.getElementById('errorMessages');

    // Clear previous errors
    errorDiv.classList.add('d-none');
    errorDiv.innerHTML = '';

    // Validate password match
    if (password !== passwordConfirm) {
        errorDiv.innerHTML = 'Passwords do not match';
        errorDiv.classList.remove('d-none');
        return;
    }

    // Get form data
    const formData = new FormData(this);
    
    // Try to get CSRF token from the form itself
    const csrfInput = this.querySelector('input[name^="csrf_"]');
    if (csrfInput) {
        console.log('CSRF Token found:', csrfInput.name, csrfInput.value);
    } else {
        console.log('No CSRF token found in form');
        // Manually add CSRF token
        formData.set('<?= csrf_token() ?>', '<?= csrf_hash() ?>');
    }

    // Show loading state
    const submitBtn = this.querySelector('button[type="submit"]');
    const originalBtnText = submitBtn.innerHTML;
    submitBtn.disabled = true;
    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Creating...';

    // Submit form
    fetch('<?= base_url("employees/process-convert-to-user") ?>', {
        method: 'POST',
        headers: {
            'X-Requested-With': 'XMLHttpRequest'
        },
        body: formData
    })
    .then(response => {
        if (!response.ok) {
            throw new Error('Network response was not ok');
        }
        return response.json();
    })
    .then(data => {
        if (data.success) {
            alert(data.message);

            // Hide modal
            const modalElement = document.getElementById('convertToUserModal');
            const modal = bootstrap.Modal.getInstance(modalElement);
            if (modal) {
                modal.hide();
            }

            // Hide the "Create User Account" button
            const convertBtn = document.getElementById('convertToUserBtn');
            if (convertBtn) {
                convertBtn.style.display = 'none';
            }

            // Reload the page to show updated information
            location.reload();
        } else {
            // Show errors
            let errorHtml = data.message || 'Failed to create user account';

            if (data.errors) {
                errorHtml += '<ul class="mb-0 mt-2">';
                for (const [field, error] of Object.entries(data.errors)) {
                    errorHtml += `<li>${error}</li>`;
                }
                errorHtml += '</ul>';
            }

            errorDiv.innerHTML = errorHtml;
            errorDiv.classList.remove('d-none');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        errorDiv.innerHTML = 'An error occurred while creating the user account';
        errorDiv.classList.remove('d-none');
    })
    .finally(() => {
        // Restore button state
        submitBtn.disabled = false;
        submitBtn.innerHTML = originalBtnText;
    });
});
// Check if employee has user account on page load to hide button if needed
document.addEventListener('DOMContentLoaded', function() {
    const employeeId = <?= $employee['employee_id'] ?>;
    fetch(`<?= base_url('employees/check-user-account/') ?>${employeeId}`)
        .then(response => response.json())
        .then(data => {
            if (data.has_account) {
                const convertBtn = document.getElementById('convertToUserBtn');
                if (convertBtn) {
                    convertBtn.style.display = 'none';
                }
            }
        })
        .catch(error => {
            console.error('Error checking user account:', error);
        });
});
</script>
<?= $this->endSection() ?>

