<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= esc($pageTitle ?? 'Dashboard') ?> - LBDI Attendance System</title>

    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>

    <style>
        :root {
            --sidebar-width: 260px;
            --header-height: 60px;
            --primary-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            --primary-color: #667eea;
            --secondary-color: #764ba2;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f8f9fa;
        }

        /* Sidebar Styles */
        .sidebar {
            position: fixed;
            top: 0;
            left: 0;
            height: 100vh;
            width: var(--sidebar-width);
            background: var(--primary-gradient);
            color: white;
            overflow-y: auto;
            transition: transform 0.3s ease;
            z-index: 1000;
        }

        .sidebar-header {
            padding: 20px;
            text-align: center;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .sidebar-header h4 {
            margin: 0;
            font-weight: 600;
            font-size: 18px;
        }

        .sidebar-menu {
            padding: 20px 0;
        }

        .menu-item {
            padding: 12px 20px;
            color: rgba(255, 255, 255, 0.8);
            text-decoration: none;
            display: flex;
            align-items: center;
            transition: all 0.3s;
            border-left: 3px solid transparent;
        }

        .menu-item:hover {
            background: rgba(255, 255, 255, 0.1);
            color: white;
            border-left-color: white;
        }

        .menu-item.active {
            background: rgba(255, 255, 255, 0.15);
            color: white;
            border-left-color: white;
        }

        .menu-item i {
            width: 25px;
            margin-right: 10px;
            font-size: 16px;
        }

        .menu-section {
            padding: 15px 20px 5px;
            font-size: 11px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
            color: rgba(255, 255, 255, 0.5);
        }

        /* Main Content Area */
        .main-wrapper {
            margin-left: var(--sidebar-width);
            min-height: 100vh;
        }

        /* Header Styles */
        .top-header {
            background: white;
            height: var(--header-height);
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.08);
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 30px;
            position: sticky;
            top: 0;
            z-index: 999;
        }

        .header-left h5 {
            margin: 0;
            color: #333;
            font-weight: 600;
        }

        .header-right {
            display: flex;
            align-items: center;
            gap: 20px;
        }

        .user-menu {
            position: relative;
        }

        .user-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            object-fit: cover;
            cursor: pointer;
            border: 2px solid #e0e0e0;
        }

        .user-dropdown {
            position: absolute;
            top: 50px;
            right: 0;
            background: white;
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            min-width: 200px;
            display: none;
            z-index: 1001;
        }

        .user-dropdown.show {
            display: block;
        }

        .user-dropdown a {
            display: block;
            padding: 12px 20px;
            color: #333;
            text-decoration: none;
            transition: background 0.2s;
        }

        .user-dropdown a:hover {
            background: #f8f9fa;
        }

        .user-dropdown a i {
            margin-right: 10px;
            width: 20px;
        }

        /* Content Area */
        .content-area {
            padding: 30px;
        }

        /* Stat Cards */
        .stat-card {
            background: white;
            border-radius: 10px;
            padding: 20px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
            transition: transform 0.2s, box-shadow 0.2s;
        }

        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);
        }

        .stat-card .icon {
            width: 50px;
            height: 50px;
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            color: white;
            margin-bottom: 15px;
        }

        .stat-card h6 {
            color: #666;
            font-size: 13px;
            font-weight: 600;
            text-transform: uppercase;
            margin-bottom: 8px;
        }

        .stat-card .value {
            font-size: 28px;
            font-weight: 700;
            color: #333;
        }

        .stat-card .change {
            font-size: 12px;
            margin-top: 5px;
        }

        /* Mobile Responsive */
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
            }

            .sidebar.show {
                transform: translateX(0);
            }

            .main-wrapper {
                margin-left: 0;
            }

            .mobile-toggle {
                display: block !important;
            }
        }

        .mobile-toggle {
            display: none;
            background: none;
            border: none;
            font-size: 24px;
            cursor: pointer;
        }

        /* Alert Styles */
        .alert {
            border-radius: 8px;
            border: none;
        }

        /* Table Styles */
        .table-card {
            background: white;
            border-radius: 10px;
            padding: 20px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        }

        .table-card h5 {
            margin-bottom: 20px;
            font-weight: 600;
        }
    </style>

    <?= $this->renderSection('styles') ?>
</head>
<body>
    <!-- Sidebar -->
    <div class="sidebar" id="sidebar">
        <div class="sidebar-header">
            <i class="fas fa-user-clock fa-2x mb-2"></i>
            <h4>LBDI Attendance</h4>
            <small><?= esc(current_user('full_name')) ?></small>
        </div>

        <div class="sidebar-menu">
            <!-- Main Menu -->
            <div class="menu-section">Main Menu</div>
            <a href="<?= base_url('dashboard') ?>" class="menu-item <?= (uri_string() == 'dashboard') ? 'active' : '' ?>">
                <i class="fas fa-home"></i>
                <span>Dashboard</span>
            </a>

            <?php if (has_permission('view-employees')): ?>
            <a href="<?= base_url('employees') ?>" class="menu-item <?= (strpos(uri_string(), 'employees') === 0) ? 'active' : '' ?>">
                <i class="fas fa-users"></i>
                <span>Employees</span>
            </a>
            <?php endif; ?>

            <?php if (has_permission('view-attendance')): ?>
            <a href="<?= base_url('attendance') ?>" class="menu-item <?= (strpos(uri_string(), 'attendance') === 0) ? 'active' : '' ?>">
                <i class="fas fa-clock"></i>
                <span>Attendance</span>
            </a>
            <?php endif; ?>

            <?php if (has_permission('view-leave-requests')): ?>
            <a href="<?= base_url('leave') ?>" class="menu-item <?= (strpos(uri_string(), 'leave') === 0) ? 'active' : '' ?>">
                <i class="fas fa-calendar-alt"></i>
                <span>Leave Management</span>
            </a>
            <?php endif; ?>

            <?php if (has_permission('view-reports')): ?>
            <a href="<?= base_url('reports') ?>" class="menu-item <?= (strpos(uri_string(), 'reports') === 0) ? 'active' : '' ?>">
                <i class="fas fa-chart-bar"></i>
                <span>Reports</span>
            </a>
            <?php endif; ?>

            <!-- Settings -->
            <?php if (has_permission('view-users') || has_permission('view-settings')): ?>
            <div class="menu-section">Administration</div>
            <?php endif; ?>

            <?php if (has_permission('view-users')): ?>
            <a href="<?= base_url('settings/users') ?>" class="menu-item <?= (strpos(uri_string(), 'settings/users') === 0) ? 'active' : '' ?>">
                <i class="fas fa-user-shield"></i>
                <span>Users</span>
            </a>
            <?php endif; ?>

            <?php if (has_permission('view-roles')): ?>
            <a href="<?= base_url('settings/roles') ?>" class="menu-item <?= (strpos(uri_string(), 'settings/roles') === 0) ? 'active' : '' ?>">
                <i class="fas fa-user-tag"></i>
                <span>Roles & Permissions</span>
            </a>
            <?php endif; ?>

            <?php if (has_permission('view-settings')): ?>
            <a href="<?= base_url('settings/locations') ?>" class="menu-item <?= (strpos(uri_string(), 'settings/locations') === 0) ? 'active' : '' ?>">
                <i class="fas fa-map-marker-alt"></i>
                <span>Locations</span>
            </a>
            <a href="<?= base_url('settings/departments') ?>" class="menu-item <?= (strpos(uri_string(), 'settings/departments') === 0) ? 'active' : '' ?>">
                <i class="fas fa-building"></i>
                <span>Departments</span>
            </a>
            <a href="<?= base_url('settings/system') ?>" class="menu-item <?= (strpos(uri_string(), 'settings/system') === 0) ? 'active' : '' ?>">
                <i class="fas fa-cog"></i>
                <span>System Settings</span>
            </a>
            <?php endif; ?>

            <?php if (has_permission('view-audit-logs')): ?>
            <a href="<?= base_url('settings/audit-logs') ?>" class="menu-item <?= (strpos(uri_string(), 'settings/audit-logs') === 0) ? 'active' : '' ?>">
                <i class="fas fa-history"></i>
                <span>Audit Logs</span>
            </a>
            <?php endif; ?>
        </div>
    </div>

    <!-- Main Content -->
    <div class="main-wrapper">
        <!-- Top Header -->
        <div class="top-header">
            <div class="header-left">
                <button class="mobile-toggle" onclick="toggleSidebar()">
                    <i class="fas fa-bars"></i>
                </button>
                <h5><?= esc($pageTitle ?? 'Dashboard') ?></h5>
            </div>

            <div class="header-right">
                <!-- Notifications -->
                <div class="notifications">
                    <i class="fas fa-bell" style="font-size: 20px; color: #666; cursor: pointer;"></i>
                </div>

                <!-- User Menu -->
                <div class="user-menu">
                    <img src="<?= user_avatar(current_user('photo')) ?>"
                         alt="User"
                         class="user-avatar"
                         onclick="toggleUserMenu()">

                    <div class="user-dropdown" id="userDropdown">
                        <a href="<?= base_url('profile') ?>">
                            <i class="fas fa-user"></i>
                            My Profile
                        </a>
                        <a href="<?= base_url('change-password') ?>">
                            <i class="fas fa-key"></i>
                            Change Password
                        </a>
                        <hr style="margin: 5px 0;">
                        <a href="<?= base_url('logout') ?>">
                            <i class="fas fa-sign-out-alt"></i>
                            Logout
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Content Area -->
        <div class="content-area">
            <!-- Flash Messages -->
            <?php if (session()->getFlashdata('success')): ?>
            <div class="alert alert-success alert-dismissible fade show">
                <i class="fas fa-check-circle me-2"></i>
                <?= session()->getFlashdata('success') ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            <?php endif; ?>

            <?php if (session()->getFlashdata('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show">
                <i class="fas fa-exclamation-circle me-2"></i>
                <?= session()->getFlashdata('error') ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            <?php endif; ?>

            <?php if (session()->getFlashdata('errors')): ?>
            <div class="alert alert-danger alert-dismissible fade show">
                <ul class="mb-0">
                    <?php foreach (session()->getFlashdata('errors') as $error): ?>
                        <li><?= esc($error) ?></li>
                    <?php endforeach; ?>
                </ul>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            <?php endif; ?>

            <!-- Page Content -->
            <?= $this->renderSection('content') ?>
        </div>
    </div>

    <!-- Bootstrap 5 JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        // Toggle user dropdown
        function toggleUserMenu() {
            document.getElementById('userDropdown').classList.toggle('show');
        }

        // Toggle sidebar on mobile
        function toggleSidebar() {
            document.getElementById('sidebar').classList.toggle('show');
        }

        // Close dropdown when clicking outside
        document.addEventListener('click', function(event) {
            const userMenu = document.querySelector('.user-menu');
            const dropdown = document.getElementById('userDropdown');

            if (!userMenu.contains(event.target)) {
                dropdown.classList.remove('show');
            }
        });
    </script>

    <?= $this->renderSection('scripts') ?>
</body>
</html>
