<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<!-- Header with Actions -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-calendar-alt me-2"></i><?= esc($pageTitle) ?></h2>
    <div>
        <?php if (has_permission('view-leave-balances')): ?>
        <a href="<?= base_url('leave/balances') ?>" class="btn btn-outline-info me-2">
            <i class="fas fa-chart-pie"></i> View Balances
        </a>
        <?php endif; ?>

        <?php if (has_permission('create-leave-request')): ?>
        <a href="<?= base_url('leave/requests/create') ?>" class="btn btn-primary">
            <i class="fas fa-plus"></i> New Request
        </a>
        <?php endif; ?>
    </div>
</div>

<!-- Filters -->
<div class="table-card mb-4">
    <form method="get" action="<?= base_url('leave/requests') ?>" class="row g-3">
        <div class="col-md-2">
            <label class="form-label">Status</label>
            <select name="status" class="form-select">
                <option value="">All Status</option>
                <option value="Pending" <?= ($filters['status'] ?? '') == 'Pending' ? 'selected' : '' ?>>Pending</option>
                <option value="Approved" <?= ($filters['status'] ?? '') == 'Approved' ? 'selected' : '' ?>>Approved</option>
                <option value="Rejected" <?= ($filters['status'] ?? '') == 'Rejected' ? 'selected' : '' ?>>Rejected</option>
            </select>
        </div>

        <div class="col-md-2">
            <label class="form-label">Leave Type</label>
            <select name="leave_type_id" class="form-select">
                <option value="">All Types</option>
                <?php foreach ($leaveTypes as $type): ?>
                <option value="<?= $type['id'] ?>" <?= ($filters['leave_type_id'] ?? '') == $type['id'] ? 'selected' : '' ?>>
                    <?= esc($type['name']) ?>
                </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="col-md-2">
            <label class="form-label">Employee</label>
            <select name="employee_id" class="form-select">
                <option value="">All Employees</option>
                <?php foreach ($employees as $employee): ?>
                <option value="<?= $employee['employee_id'] ?>" <?= ($filters['employee_id'] ?? '') == $employee['employee_id'] ? 'selected' : '' ?>>
                    <?= esc($employee['first_name'] . ' ' . $employee['last_name']) ?>
                </option>
                <?php endforeach; ?>
            </select>
        </div>

        <?php if (is_super_admin()): ?>
        <div class="col-md-2">
            <label class="form-label">Location</label>
            <select name="location_id" class="form-select">
                <option value="">All Locations</option>
                <?php foreach ($locations as $location): ?>
                <option value="<?= $location['id'] ?>" <?= ($filters['location_id'] ?? '') == $location['id'] ? 'selected' : '' ?>>
                    <?= esc($location['name']) ?>
                </option>
                <?php endforeach; ?>
            </select>
        </div>
        <?php endif; ?>

        <div class="col-md-2 d-flex align-items-end">
            <button type="submit" class="btn btn-primary w-100">
                <i class="fas fa-filter"></i> Filter
            </button>
        </div>
    </form>
</div>

<!-- Flash Messages -->
<?php if (session()->has('success')): ?>
<div class="alert alert-success alert-dismissible fade show" role="alert">
    <i class="fas fa-check-circle me-2"></i><?= session('success') ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<!-- Leave Requests Table -->
<div class="table-card">
    <div class="table-responsive">
        <table class="table table-hover align-middle">
            <thead>
                <tr>
                    <th>Employee</th>
                    <th>Leave Type</th>
                    <th>Period</th>
                    <th>Days</th>
                    <th>Status</th>
                    <th>Submitted</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($requests)): ?>
                    <?php foreach ($requests as $request): ?>
                    <tr>
                        <td>
                            <div class="d-flex align-items-center">
                                <?php if (!empty($request['photo'])): ?>
                                <img src="<?= base_url('uploads/employees/' . $request['photo']) ?>"
                                     class="rounded-circle me-2"
                                     style="width: 35px; height: 35px; object-fit: cover;">
                                <?php else: ?>
                                <div class="rounded-circle bg-secondary text-white d-flex align-items-center justify-content-center me-2"
                                     style="width: 35px; height: 35px; font-size: 14px;">
                                    <i class="fas fa-user"></i>
                                </div>
                                <?php endif; ?>
                                <div>
                                    <strong><?= esc($request['first_name'] . ' ' . $request['last_name']) ?></strong>
                                    <br><small class="text-muted"><?= esc($request['emp_id']) ?></small>
                                </div>
                            </div>
                        </td>
                        <td>
                            <span class="badge" style="background-color: <?= esc($request['color']) ?>">
                                <?= esc($request['leave_type_name']) ?>
                            </span>
                        </td>
                        <td>
                            <?= date('M d', strtotime($request['start_date'])) ?> -
                            <?= date('M d, Y', strtotime($request['end_date'])) ?>
                        </td>
                        <td><strong><?= number_format($request['total_days'], 1) ?></strong> day(s)</td>
                        <td>
                            <?php
                            $statusColors = [
                                'Pending' => 'warning',
                                'Approved' => 'success',
                                'Rejected' => 'danger',
                            ];
                            $statusColor = $statusColors[$request['status']] ?? 'secondary';
                            ?>
                            <span class="badge bg-<?= $statusColor ?>">
                                <?= esc($request['status']) ?>
                            </span>
                        </td>
                        <td>
                            <small class="text-muted">
                                <?= date('M d, Y', strtotime($request['created_at'])) ?>
                            </small>
                        </td>
                        <td>
                            <div class="btn-group btn-group-sm">
                                <a href="<?= base_url('leave/requests/view/' . $request['id']) ?>"
                                   class="btn btn-outline-info" title="View Details">
                                    <i class="fas fa-eye"></i>
                                </a>

                                <?php
                                // Check if current user can approve this leave request
                                $canApprove = has_permission('approve-leave') && $request['status'] == 'Pending';
                                if ($canApprove && !is_super_admin()) {
                                    // Must be a manager in the same department
                                    $canApprove = $isManager && ($currentUserDepartmentId == $request['department_id']);
                                }
                                ?>
                                <?php if ($canApprove): ?>
                                <button class="btn btn-outline-success approve-btn"
                                        data-id="<?= $request['id'] ?>"
                                        data-name="<?= esc($request['first_name'] . ' ' . $request['last_name']) ?>"
                                        title="Approve">
                                    <i class="fas fa-check"></i>
                                </button>
                                <button class="btn btn-outline-danger reject-btn"
                                        data-id="<?= $request['id'] ?>"
                                        data-name="<?= esc($request['first_name'] . ' ' . $request['last_name']) ?>"
                                        title="Reject">
                                    <i class="fas fa-times"></i>
                                </button>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="7" class="text-center py-5 text-muted">
                            <i class="fas fa-calendar-times fa-3x mb-3"></i>
                            <p>No leave requests found</p>
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <?php if (!empty($requests)): ?>
    <div class="p-3 border-top">
        <div class="text-muted">
            Showing <?= count($requests) ?> request(s)
        </div>
    </div>
    <?php endif; ?>
</div>

<!-- Approval Modal -->
<div class="modal fade" id="approveModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-success text-white">
                <h5 class="modal-title"><i class="fas fa-check-circle me-2"></i>Approve Leave Request</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to approve the leave request for <strong id="approveEmployeeName"></strong>?</p>
                <div class="mb-3">
                    <label class="form-label">Comments (Optional)</label>
                    <textarea class="form-control" id="approveComments" rows="3" placeholder="Add any comments..."></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-success" id="confirmApprove">Approve</button>
            </div>
        </div>
    </div>
</div>

<!-- Reject Modal -->
<div class="modal fade" id="rejectModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title"><i class="fas fa-times-circle me-2"></i>Reject Leave Request</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to reject the leave request for <strong id="rejectEmployeeName"></strong>?</p>
                <div class="mb-3">
                    <label class="form-label">Rejection Reason <span class="text-danger">*</span></label>
                    <textarea class="form-control" id="rejectionReason" rows="3" placeholder="Enter reason for rejection..." required></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-danger" id="confirmReject">Reject</button>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
let currentRequestId = null;
const approveModal = new bootstrap.Modal(document.getElementById('approveModal'));
const rejectModal = new bootstrap.Modal(document.getElementById('rejectModal'));

// Approve button click
document.querySelectorAll('.approve-btn').forEach(btn => {
    btn.addEventListener('click', function() {
        currentRequestId = this.dataset.id;
        document.getElementById('approveEmployeeName').textContent = this.dataset.name;
        document.getElementById('approveComments').value = '';
        approveModal.show();
    });
});

// Reject button click
document.querySelectorAll('.reject-btn').forEach(btn => {
    btn.addEventListener('click', function() {
        currentRequestId = this.dataset.id;
        document.getElementById('rejectEmployeeName').textContent = this.dataset.name;
        document.getElementById('rejectionReason').value = '';
        rejectModal.show();
    });
});

// Confirm approve
document.getElementById('confirmApprove').addEventListener('click', function() {
    const comments = document.getElementById('approveComments').value;

    fetch(`<?= base_url('leave/requests/approve/') ?>${currentRequestId}`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-Requested-With': 'XMLHttpRequest'
        },
        body: JSON.stringify({ comments: comments })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            window.location.reload();
        } else {
            alert(data.message || 'Failed to approve request');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('An error occurred');
    });
});

// Confirm reject
document.getElementById('confirmReject').addEventListener('click', function() {
    const reason = document.getElementById('rejectionReason').value;

    if (!reason) {
        alert('Please enter a rejection reason');
        return;
    }

    fetch(`<?= base_url('leave/requests/reject/') ?>${currentRequestId}`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-Requested-With': 'XMLHttpRequest'
        },
        body: JSON.stringify({ rejection_reason: reason })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            window.location.reload();
        } else {
            alert(data.message || 'Failed to reject request');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('An error occurred');
    });
});
</script>
<?= $this->endSection() ?>
