<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<style>
    .schedule-card {
        background: white;
        border-radius: 12px;
        padding: 20px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        margin-bottom: 20px;
        border-left: 4px solid #f093fb;
        transition: all 0.3s;
    }

    .schedule-card:hover {
        box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);
        transform: translateY(-2px);
    }

    .schedule-header {
        display: flex;
        justify-content: between;
        align-items: start;
        margin-bottom: 15px;
    }

    .schedule-title {
        font-weight: 600;
        font-size: 16px;
        color: #333;
        margin-bottom: 5px;
    }

    .schedule-meta {
        display: flex;
        gap: 15px;
        flex-wrap: wrap;
        margin-top: 10px;
    }

    .meta-item {
        display: flex;
        align-items: center;
        font-size: 13px;
        color: #666;
    }

    .meta-item i {
        margin-right: 5px;
        color: #999;
    }

    .schedule-actions {
        display: flex;
        gap: 10px;
        margin-top: 15px;
    }

    .frequency-badge {
        padding: 4px 10px;
        border-radius: 20px;
        font-size: 11px;
        font-weight: 600;
        text-transform: uppercase;
    }

    .frequency-daily {
        background: #e3f2fd;
        color: #1976d2;
    }

    .frequency-weekly {
        background: #f3e5f5;
        color: #7b1fa2;
    }

    .frequency-monthly {
        background: #e8f5e9;
        color: #388e3c;
    }

    .status-badge {
        padding: 4px 10px;
        border-radius: 20px;
        font-size: 11px;
        font-weight: 600;
        text-transform: uppercase;
    }

    .status-active {
        background: #d4edda;
        color: #155724;
    }

    .status-inactive {
        background: #f8d7da;
        color: #721c24;
    }

    .empty-state {
        text-align: center;
        padding: 80px 20px;
        background: white;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    }

    .empty-state i {
        font-size: 80px;
        color: #e0e0e0;
        margin-bottom: 20px;
    }

    .empty-state h5 {
        color: #666;
        margin-bottom: 10px;
    }

    .empty-state p {
        color: #999;
        margin-bottom: 30px;
    }

    .modal-header {
        background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
        color: white;
    }

    .modal-header .btn-close {
        filter: brightness(0) invert(1);
    }
</style>

<!-- Page Header -->
<div class="row mb-4">
    <div class="col-md-12">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h3 class="mb-2">Scheduled Reports</h3>
                <p class="text-muted mb-0">Manage automated reports that are generated on a recurring schedule</p>
            </div>
            <div>
                <a href="<?= base_url('reports') ?>" class="btn btn-outline-secondary me-2">
                    <i class="fas fa-arrow-left me-2"></i>Back to Reports
                </a>
                <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createScheduleModal">
                    <i class="fas fa-plus me-2"></i>Create Schedule
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Statistics Row -->
<div class="row g-3 mb-4">
    <div class="col-md-3">
        <div class="stat-card">
            <div class="icon" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
                <i class="fas fa-calendar-check"></i>
            </div>
            <h6>Total Schedules</h6>
            <div class="value"><?= count($scheduledReports) ?></div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="icon" style="background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);">
                <i class="fas fa-check-circle"></i>
            </div>
            <h6>Active Schedules</h6>
            <div class="value">
                <?= count(array_filter($scheduledReports, fn($r) => $r['is_active'] == 1)) ?>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="icon" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                <i class="fas fa-clock"></i>
            </div>
            <h6>Next Run</h6>
            <div class="value" style="font-size: 14px;">
                <?php
                $nextRun = null;
                foreach ($scheduledReports as $report) {
                    if ($report['is_active'] && $report['next_run_date']) {
                        if (!$nextRun || strtotime($report['next_run_date']) < strtotime($nextRun)) {
                            $nextRun = $report['next_run_date'];
                        }
                    }
                }
                echo $nextRun ? date('M d, h:i A', strtotime($nextRun)) : 'N/A';
                ?>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="icon" style="background: linear-gradient(135deg, #ee0979 0%, #ff6a00 100%);">
                <i class="fas fa-paper-plane"></i>
            </div>
            <h6>Last Generated</h6>
            <div class="value" style="font-size: 14px;">
                <?php
                $lastRun = null;
                foreach ($scheduledReports as $report) {
                    if ($report['last_run_date']) {
                        if (!$lastRun || strtotime($report['last_run_date']) > strtotime($lastRun)) {
                            $lastRun = $report['last_run_date'];
                        }
                    }
                }
                echo $lastRun ? date('M d, h:i A', strtotime($lastRun)) : 'Never';
                ?>
            </div>
        </div>
    </div>
</div>

<!-- Scheduled Reports List -->
<?php if (!empty($scheduledReports)): ?>
    <div class="row">
        <div class="col-md-12">
            <?php foreach ($scheduledReports as $schedule): ?>
            <div class="schedule-card">
                <div class="d-flex justify-content-between align-items-start">
                    <div class="flex-grow-1">
                        <div class="schedule-title">
                            <i class="fas fa-<?= $schedule['report_type'] == 'attendance' ? 'clock' : 'calendar-alt' ?> me-2"></i>
                            <?= esc($schedule['report_name']) ?>
                        </div>

                        <div class="schedule-meta">
                            <div class="meta-item">
                                <i class="fas fa-tag"></i>
                                <span class="frequency-badge frequency-<?= $schedule['frequency'] ?>">
                                    <?= ucfirst($schedule['frequency']) ?>
                                </span>
                            </div>
                            <div class="meta-item">
                                <i class="fas fa-circle"></i>
                                <span class="status-badge status-<?= $schedule['is_active'] ? 'active' : 'inactive' ?>">
                                    <?= $schedule['is_active'] ? 'Active' : 'Inactive' ?>
                                </span>
                            </div>
                            <div class="meta-item">
                                <i class="fas fa-file-alt"></i>
                                <strong><?= ucfirst($schedule['report_type']) ?> Report</strong>
                            </div>
                            <div class="meta-item">
                                <i class="fas fa-download"></i>
                                Export as <strong><?= strtoupper($schedule['export_format']) ?></strong>
                            </div>
                        </div>

                        <div class="schedule-meta">
                            <?php if ($schedule['recipients']): ?>
                            <div class="meta-item">
                                <i class="fas fa-envelope"></i>
                                Recipients: <?= esc($schedule['recipients']) ?>
                            </div>
                            <?php endif; ?>
                            <?php if ($schedule['next_run_date']): ?>
                            <div class="meta-item">
                                <i class="fas fa-clock"></i>
                                Next run: <strong><?= date('M d, Y h:i A', strtotime($schedule['next_run_date'])) ?></strong>
                            </div>
                            <?php endif; ?>
                            <?php if ($schedule['last_run_date']): ?>
                            <div class="meta-item">
                                <i class="fas fa-check"></i>
                                Last run: <?= date('M d, Y h:i A', strtotime($schedule['last_run_date'])) ?>
                            </div>
                            <?php endif; ?>
                        </div>

                        <?php if ($schedule['filter_params']): ?>
                        <div class="mt-2">
                            <small class="text-muted">
                                <i class="fas fa-filter me-1"></i>
                                Filters applied: <?= esc($schedule['filter_params']) ?>
                            </small>
                        </div>
                        <?php endif; ?>

                        <div class="schedule-actions">
                            <button class="btn btn-sm btn-outline-primary" onclick="runScheduleNow(<?= $schedule['id'] ?>)">
                                <i class="fas fa-play me-1"></i>Run Now
                            </button>
                            <button class="btn btn-sm btn-outline-secondary" onclick="editSchedule(<?= $schedule['id'] ?>)">
                                <i class="fas fa-edit me-1"></i>Edit
                            </button>
                            <?php if ($schedule['is_active']): ?>
                            <button class="btn btn-sm btn-outline-warning" onclick="toggleSchedule(<?= $schedule['id'] ?>, 0)">
                                <i class="fas fa-pause me-1"></i>Pause
                            </button>
                            <?php else: ?>
                            <button class="btn btn-sm btn-outline-success" onclick="toggleSchedule(<?= $schedule['id'] ?>, 1)">
                                <i class="fas fa-play me-1"></i>Activate
                            </button>
                            <?php endif; ?>
                            <button class="btn btn-sm btn-outline-danger" onclick="deleteSchedule(<?= $schedule['id'] ?>)">
                                <i class="fas fa-trash me-1"></i>Delete
                            </button>
                        </div>
                    </div>

                    <div class="ms-3">
                        <small class="text-muted">
                            Created by: <?= esc($schedule['full_name']) ?><br>
                            <small><?= date('M d, Y', strtotime($schedule['created_at'])) ?></small>
                        </small>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
<?php else: ?>
    <!-- Empty State -->
    <div class="empty-state">
        <i class="fas fa-calendar-times"></i>
        <h5>No Scheduled Reports</h5>
        <p>You haven't created any scheduled reports yet. Create your first scheduled report to automate your reporting workflow.</p>
        <button class="btn btn-primary btn-lg" data-bs-toggle="modal" data-bs-target="#createScheduleModal">
            <i class="fas fa-plus me-2"></i>Create Your First Schedule
        </button>
    </div>
<?php endif; ?>

<!-- Create Schedule Modal -->
<div class="modal fade" id="createScheduleModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fas fa-calendar-plus me-2"></i>Create Scheduled Report
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="scheduleForm">
                    <div class="row g-3">
                        <div class="col-md-12">
                            <label class="form-label">Report Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="report_name" required
                                   placeholder="e.g., Monthly Attendance Summary">
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Report Type <span class="text-danger">*</span></label>
                            <select class="form-select" name="report_type" required>
                                <option value="">Select Report Type</option>
                                <option value="attendance">Attendance Report</option>
                                <option value="leave">Leave Report</option>
                            </select>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Frequency <span class="text-danger">*</span></label>
                            <select class="form-select" name="frequency" required>
                                <option value="">Select Frequency</option>
                                <option value="daily">Daily</option>
                                <option value="weekly">Weekly</option>
                                <option value="monthly">Monthly</option>
                            </select>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Export Format <span class="text-danger">*</span></label>
                            <select class="form-select" name="export_format" required>
                                <option value="pdf">PDF Document</option>
                                <option value="excel">Excel Spreadsheet</option>
                                <option value="csv">CSV File</option>
                            </select>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Run Time <span class="text-danger">*</span></label>
                            <input type="time" class="form-control" name="run_time" value="09:00" required>
                        </div>

                        <div class="col-md-12">
                            <label class="form-label">Recipients (Email Addresses) <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="recipients" required
                                   placeholder="email1@example.com, email2@example.com">
                            <small class="text-muted">Separate multiple emails with commas</small>
                        </div>

                        <div class="col-md-12">
                            <label class="form-label">Filter Parameters (Optional)</label>
                            <textarea class="form-control" name="filter_params" rows="2"
                                      placeholder="e.g., department_id=1, location_id=2"></textarea>
                            <small class="text-muted">Add custom filters for the report (key=value format)</small>
                        </div>

                        <div class="col-md-12">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="is_active" id="isActive" checked>
                                <label class="form-check-label" for="isActive">
                                    Activate immediately after creation
                                </label>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" onclick="saveSchedule()">
                    <i class="fas fa-save me-2"></i>Create Schedule
                </button>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
    function saveSchedule() {
        alert('Schedule creation will be implemented with backend integration');
        // TODO: Implement AJAX call to save schedule
    }

    function runScheduleNow(id) {
        if (confirm('Run this scheduled report now?')) {
            alert('Report generation will be implemented with backend integration');
            // TODO: Implement AJAX call to run schedule
        }
    }

    function editSchedule(id) {
        alert('Edit functionality will be implemented with backend integration');
        // TODO: Implement edit modal with schedule data
    }

    function toggleSchedule(id, status) {
        const action = status ? 'activate' : 'pause';
        if (confirm(`Are you sure you want to ${action} this schedule?`)) {
            alert('Toggle functionality will be implemented with backend integration');
            // TODO: Implement AJAX call to toggle schedule status
        }
    }

    function deleteSchedule(id) {
        if (confirm('Are you sure you want to delete this schedule? This action cannot be undone.')) {
            alert('Delete functionality will be implemented with backend integration');
            // TODO: Implement AJAX call to delete schedule
        }
    }
</script>
<?= $this->endSection() ?>
