<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<style>
    .stats-row {
        display: flex;
        gap: 15px;
        margin-bottom: 25px;
    }

    .stat-box {
        flex: 1;
        background: white;
        border-radius: 12px;
        padding: 20px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        display: flex;
        align-items: center;
        gap: 15px;
    }

    .stat-icon {
        width: 50px;
        height: 50px;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 24px;
        color: white;
    }

    .stat-content h3 {
        margin: 0;
        font-size: 28px;
        font-weight: 700;
        color: #333;
    }

    .stat-content p {
        margin: 0;
        font-size: 13px;
        color: #666;
    }

    .filter-card {
        background: white;
        border-radius: 12px;
        padding: 20px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        margin-bottom: 20px;
    }

    .logs-table-card {
        background: white;
        border-radius: 12px;
        padding: 25px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    }

    .log-row {
        border-bottom: 1px solid #f0f0f0;
        padding: 15px 0;
        transition: background 0.2s;
    }

    .log-row:hover {
        background: #f8f9fa;
    }

    .log-header {
        display: flex;
        justify-content: space-between;
        align-items: start;
        margin-bottom: 8px;
    }

    .log-user {
        font-weight: 600;
        color: #333;
    }

    .log-time {
        color: #999;
        font-size: 13px;
    }

    .log-action {
        padding: 3px 10px;
        border-radius: 4px;
        font-size: 11px;
        font-weight: 600;
        text-transform: uppercase;
        margin-right: 8px;
    }

    .action-create {
        background: #d4edda;
        color: #155724;
    }

    .action-update {
        background: #d1ecf1;
        color: #0c5460;
    }

    .action-delete {
        background: #f8d7da;
        color: #721c24;
    }

    .action-view {
        background: #e2e3e5;
        color: #383d41;
    }

    .log-module {
        background: #667eea;
        color: white;
        padding: 3px 10px;
        border-radius: 4px;
        font-size: 11px;
        font-weight: 600;
        margin-right: 8px;
    }

    .log-description {
        color: #666;
        font-size: 14px;
        margin-top: 5px;
    }

    .log-meta {
        display: flex;
        gap: 15px;
        margin-top: 8px;
        font-size: 12px;
        color: #999;
    }

    .log-meta i {
        margin-right: 5px;
    }

    .pagination {
        margin-top: 20px;
    }

    .empty-state {
        text-align: center;
        padding: 60px 20px;
        color: #999;
    }

    .empty-state i {
        font-size: 64px;
        margin-bottom: 20px;
        opacity: 0.3;
    }

    .view-details-btn {
        cursor: pointer;
        color: #667eea;
        text-decoration: none;
        font-size: 12px;
    }

    .view-details-btn:hover {
        text-decoration: underline;
    }
</style>

<!-- Page Header -->
<div class="row mb-4">
    <div class="col-md-12">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h3 class="mb-2">Audit Logs</h3>
                <p class="text-muted mb-0">Track all system activities and user actions</p>
            </div>
            <div class="d-flex gap-2">
                <a href="<?= base_url('settings/audit-logs/export?' . http_build_query($filters)) ?>" class="btn btn-outline-success">
                    <i class="fas fa-download me-2"></i>Export CSV
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Statistics -->
<div class="stats-row">
    <div class="stat-box">
        <div class="stat-icon" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
            <i class="fas fa-history"></i>
        </div>
        <div class="stat-content">
            <h3><?= number_format($stats['total']) ?></h3>
            <p>Total Logs</p>
        </div>
    </div>

    <div class="stat-box">
        <div class="stat-icon" style="background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);">
            <i class="fas fa-plus-circle"></i>
        </div>
        <div class="stat-content">
            <h3><?= number_format($stats['actions']['create'] ?? 0) ?></h3>
            <p>Create Actions</p>
        </div>
    </div>

    <div class="stat-box">
        <div class="stat-icon" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
            <i class="fas fa-edit"></i>
        </div>
        <div class="stat-content">
            <h3><?= number_format($stats['actions']['update'] ?? 0) ?></h3>
            <p>Update Actions</p>
        </div>
    </div>

    <div class="stat-box">
        <div class="stat-icon" style="background: linear-gradient(135deg, #ee0979 0%, #ff6a00 100%);">
            <i class="fas fa-trash"></i>
        </div>
        <div class="stat-content">
            <h3><?= number_format($stats['actions']['delete'] ?? 0) ?></h3>
            <p>Delete Actions</p>
        </div>
    </div>
</div>

<!-- Filters -->
<div class="filter-card">
    <form method="GET" action="<?= base_url('settings/audit-logs') ?>" id="filterForm">
        <div class="row g-3">
            <div class="col-md-3">
                <label class="form-label">Date From</label>
                <input type="date" class="form-control" name="date_from" value="<?= esc($filters['date_from']) ?>">
            </div>

            <div class="col-md-3">
                <label class="form-label">Date To</label>
                <input type="date" class="form-control" name="date_to" value="<?= esc($filters['date_to']) ?>">
            </div>

            <div class="col-md-2">
                <label class="form-label">User</label>
                <select class="form-select" name="user_id">
                    <option value="">All Users</option>
                    <?php foreach ($users as $user): ?>
                        <option value="<?= $user['id'] ?>" <?= $filters['user_id'] == $user['id'] ? 'selected' : '' ?>>
                            <?= esc($user['full_name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="col-md-2">
                <label class="form-label">Module</label>
                <select class="form-select" name="module">
                    <option value="">All Modules</option>
                    <?php foreach ($modules as $module): ?>
                        <option value="<?= esc($module['module']) ?>" <?= $filters['module'] == $module['module'] ? 'selected' : '' ?>>
                            <?= esc($module['module']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="col-md-2">
                <label class="form-label">Action</label>
                <select class="form-select" name="action">
                    <option value="">All Actions</option>
                    <?php foreach ($actions as $action): ?>
                        <option value="<?= esc($action['action']) ?>" <?= $filters['action'] == $action['action'] ? 'selected' : '' ?>>
                            <?= esc(ucfirst($action['action'])) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="col-md-8">
                <label class="form-label">Search</label>
                <input type="text" class="form-control" name="search"
                       value="<?= esc($filters['search']) ?>"
                       placeholder="Search by description, username, or IP address...">
            </div>

            <div class="col-md-4 d-flex align-items-end">
                <button type="submit" class="btn btn-primary me-2">
                    <i class="fas fa-search me-2"></i>Filter
                </button>
                <a href="<?= base_url('settings/audit-logs') ?>" class="btn btn-outline-secondary">
                    <i class="fas fa-redo me-2"></i>Reset
                </a>
            </div>
        </div>
    </form>
</div>

<!-- Logs Table -->
<div class="logs-table-card">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h5 class="mb-0">
            <i class="fas fa-list me-2"></i>Activity Logs
        </h5>
        <span class="text-muted">
            Showing <?= count($logs) ?> of <?= number_format($pagination['total_logs']) ?> logs
        </span>
    </div>

    <?php if (!empty($logs)): ?>
        <?php foreach ($logs as $log): ?>
        <div class="log-row" id="log-<?= $log['id'] ?>">
            <div class="log-header">
                <div>
                    <span class="log-user">
                        <i class="fas fa-user me-1"></i>
                        <?= esc($log['full_name'] ?? $log['username'] ?? 'System') ?>
                    </span>
                </div>
                <div class="log-time">
                    <i class="fas fa-clock me-1"></i>
                    <?= date('M d, Y h:i A', strtotime($log['created_at'])) ?>
                </div>
            </div>

            <div>
                <span class="log-action action-<?= esc($log['action']) ?>">
                    <?= esc(ucfirst($log['action'])) ?>
                </span>
                <span class="log-module">
                    <?= esc($log['module']) ?>
                </span>
            </div>

            <div class="log-description">
                <?= esc($log['description']) ?>
            </div>

            <div class="log-meta">
                <span>
                    <i class="fas fa-network-wired"></i>
                    <?= esc($log['ip_address']) ?>
                </span>
                <?php if ($log['record_id']): ?>
                <span>
                    <i class="fas fa-hashtag"></i>
                    Record ID: <?= esc($log['record_id']) ?>
                </span>
                <?php endif; ?>
                <span>
                    <a href="#" class="view-details-btn" onclick="viewLogDetails(<?= $log['id'] ?>); return false;">
                        <i class="fas fa-eye"></i> View Details
                    </a>
                </span>
            </div>
        </div>
        <?php endforeach; ?>

        <!-- Pagination -->
        <?php if ($pagination['total_pages'] > 1): ?>
        <nav class="pagination">
            <ul class="pagination justify-content-center">
                <?php for ($i = 1; $i <= $pagination['total_pages']; $i++): ?>
                    <li class="page-item <?= $i == $pagination['current_page'] ? 'active' : '' ?>">
                        <a class="page-link" href="?<?= http_build_query(array_merge($filters, ['page' => $i])) ?>">
                            <?= $i ?>
                        </a>
                    </li>
                <?php endfor; ?>
            </ul>
        </nav>
        <?php endif; ?>
    <?php else: ?>
        <div class="empty-state">
            <i class="fas fa-inbox"></i>
            <h5>No Logs Found</h5>
            <p>No audit logs match your current filters. Try adjusting your search criteria.</p>
        </div>
    <?php endif; ?>
</div>

<!-- Log Details Modal -->
<div class="modal fade" id="logDetailsModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white;">
                <h5 class="modal-title">
                    <i class="fas fa-info-circle me-2"></i>Log Details
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" style="filter: brightness(0) invert(1);"></button>
            </div>
            <div class="modal-body" id="logDetailsContent">
                <div class="text-center py-4">
                    <div class="spinner-border text-primary" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
    function viewLogDetails(logId) {
        const modal = new bootstrap.Modal(document.getElementById('logDetailsModal'));
        modal.show();

        fetch(`<?= base_url('settings/audit-logs/view') ?>/${logId}`)
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    displayLogDetails(data.log);
                } else {
                    document.getElementById('logDetailsContent').innerHTML = `
                        <div class="alert alert-danger">
                            <i class="fas fa-exclamation-circle me-2"></i>${data.message}
                        </div>
                    `;
                }
            })
            .catch(error => {
                console.error('Error:', error);
                document.getElementById('logDetailsContent').innerHTML = `
                    <div class="alert alert-danger">
                        <i class="fas fa-exclamation-circle me-2"></i>Failed to load log details
                    </div>
                `;
            });
    }

    // HTML escape function for security
    function escapeHtml(text) {
        const div = document.createElement('div');
        div.textContent = text;
        return div.innerHTML;
    }

    function displayLogDetails(log) {
        const actionClass = 'action-' + escapeHtml(log.action.toLowerCase());
        const oldRecords = log.old_values ? JSON.parse(log.old_values) : null;
        const newReocrds = log.new_values ? JSON.parse(log.new_values) : null;

        let changesHtml = '';
        if (oldRecords || newReocrds) {
            let oldValues = JSON.parse(oldRecords);
            let newValues = JSON.parse(newReocrds);
            changesHtml = '<h6 class="mt-3"><i class="fas fa-exchange-alt me-2"></i>Changes</h6><div class="table-responsive"><table class="table table-sm table-bordered">';
            changesHtml += '<thead><tr><th width="30%">Field</th><th width="35%">Old Value</th><th width="35%">New Value</th></tr></thead><tbody>';

            if (oldValues && newValues) {
                // Get all unique keys from both objects
                const allKeys = new Set([...Object.keys(oldValues), ...Object.keys(newValues)]);

                allKeys.forEach(key => {
                    const oldVal = oldValues[key];
                    const newVal = newValues[key];

                    // Convert to strings for comparison
                    const oldStr = oldVal !== undefined && oldVal !== null ? String(oldVal) : '';
                    const newStr = newVal !== undefined && newVal !== null ? String(newVal) : '';

                    // Only show if values are different
                    
                    if (oldStr !== newStr) {
                        changesHtml += `<tr>
                            <td><strong>${escapeHtml(key)}</strong></td>
                            <td>${oldStr ? escapeHtml(oldStr) : '<em class="text-muted">empty</em>'}</td>
                            <td>${newStr ? escapeHtml(newStr) : '<em class="text-muted">empty</em>'}</td>
                        </tr>`;
                    }
                });
            } else if (newValues) {
                // For create actions, show only new values
                Object.keys(newValues).forEach(key => {
                    const value = newValues[key];
                    if (value !== undefined && value !== null) {
                        changesHtml += `<tr>
                            <td><strong>${escapeHtml(key)}</strong></td>
                            <td><em class="text-muted">-</em></td>
                            <td>${escapeHtml(String(value))}</td>
                        </tr>`;
                    }
                });
            } else if (oldValues) {
                // For delete actions, show only old values
                Object.keys(oldValues).forEach(key => {
                    const value = oldValues[key];
                    if (value !== undefined && value !== null) {
                        changesHtml += `<tr>
                            <td><strong>${escapeHtml(key)}</strong></td>
                            <td>${escapeHtml(String(value))}</td>
                            <td><em class="text-muted">-</em></td>
                        </tr>`;
                    }
                });
            }
            changesHtml += '</tbody></table></div>';
        }

        document.getElementById('logDetailsContent').innerHTML = `
            <div class="row mb-3">
                <div class="col-md-6">
                    <strong><i class="fas fa-user me-2 text-primary"></i>User:</strong><br>
                    <div class="ms-4">${escapeHtml(log.full_name || log.username || 'System')}
                    ${log.email ? '<br><small class="text-muted">' + escapeHtml(log.email) + '</small>' : ''}</div>
                </div>
                <div class="col-md-6">
                    <strong><i class="fas fa-clock me-2 text-primary"></i>Date & Time:</strong><br>
                    <div class="ms-4">${new Date(log.created_at).toLocaleString()}</div>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <strong><i class="fas fa-cube me-2 text-primary"></i>Module:</strong><br>
                    <div class="ms-4"><span class="log-module">${escapeHtml(log.module)}</span></div>
                </div>
                <div class="col-md-6">
                    <strong><i class="fas fa-bolt me-2 text-primary"></i>Action:</strong><br>
                    <div class="ms-4"><span class="log-action ${actionClass}">${escapeHtml(log.action.toUpperCase())}</span></div>
                </div>
            </div>

            ${log.record_id ? `
            <div class="mb-3">
                <strong><i class="fas fa-hashtag me-2 text-primary"></i>Record ID:</strong><br>
                <div class="ms-4"><code>${escapeHtml(String(log.record_id))}</code></div>
            </div>
            ` : ''}

            <div class="mb-3">
                <strong><i class="fas fa-info-circle me-2 text-primary"></i>Description:</strong><br>
                <div class="ms-4">${escapeHtml(log.description)}</div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <strong><i class="fas fa-network-wired me-2 text-primary"></i>IP Address:</strong><br>
                    <div class="ms-4"><code>${escapeHtml(log.ip_address)}</code></div>
                </div>
                <div class="col-md-6">
                    <strong><i class="fas fa-desktop me-2 text-primary"></i>User Agent:</strong><br>
                    <div class="ms-4"><small>${escapeHtml(log.user_agent || 'N/A')}</small></div>
                </div>
            </div>

            ${changesHtml}
        `;
    }

    // Auto-submit form when filters change (optional)
    document.querySelectorAll('#filterForm select').forEach(select => {
        select.addEventListener('change', function() {
            // Uncomment the line below to auto-submit on change
            // document.getElementById('filterForm').submit();
        });
    });
</script>
<?= $this->endSection() ?>
