<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<style>
    .form-card {
        background: white;
        border-radius: 12px;
        padding: 30px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        margin-bottom: 20px;
    }

    .form-card h5 {
        font-weight: 600;
        margin-bottom: 20px;
        color: #333;
        display: flex;
        align-items: center;
    }

    .form-card h5 i {
        width: 40px;
        height: 40px;
        border-radius: 8px;
        background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        margin-right: 15px;
    }

    .info-box {
        background: #e3f2fd;
        border-left: 4px solid #2196f3;
        padding: 15px;
        border-radius: 8px;
        margin-bottom: 20px;
    }

    .info-box i {
        color: #2196f3;
        margin-right: 10px;
    }

    .stats-mini {
        display: flex;
        gap: 15px;
        margin-bottom: 20px;
    }

    .stat-mini {
        background: #f8f9fa;
        padding: 12px 20px;
        border-radius: 8px;
        flex: 1;
        text-align: center;
    }

    .stat-mini h4 {
        margin: 0;
        font-size: 24px;
        color: #11998e;
    }

    .stat-mini p {
        margin: 0;
        font-size: 12px;
        color: #666;
    }

    .form-section {
        margin-bottom: 30px;
    }

    .form-section:last-child {
        margin-bottom: 0;
    }

    .coordinate-input {
        font-family: 'Courier New', monospace;
    }

    .sticky-footer {
        position: sticky;
        bottom: 0;
        background: white;
        padding: 20px 30px;
        box-shadow: 0 -2px 8px rgba(0, 0, 0, 0.08);
        border-radius: 12px;
        margin-top: 20px;
    }

    .required-note {
        color: #dc3545;
        font-size: 13px;
        margin-bottom: 20px;
    }

    .helper-text {
        display: block;
        margin-top: 5px;
        font-size: 12px;
        color: #666;
    }

    .map-link-box {
        background: #e8f5e9;
        border: 1px solid #4caf50;
        border-radius: 8px;
        padding: 12px;
        margin-top: 10px;
        text-align: center;
    }

    .map-link-box a {
        color: #2e7d32;
        font-weight: 600;
        text-decoration: none;
    }

    .map-link-box a:hover {
        text-decoration: underline;
    }
</style>

<!-- Page Header -->
<div class="row mb-4">
    <div class="col-md-12">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h3 class="mb-2">Edit Location: <?= esc($location['name']) ?></h3>
                <p class="text-muted mb-0">Modify location details and settings</p>
            </div>
            <a href="<?= base_url('settings/locations') ?>" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left me-2"></i>Back to Locations
            </a>
        </div>
    </div>
</div>

<!-- Stats -->
<div class="stats-mini">
    <div class="stat-mini">
        <h4><?= $employeeCount ?></h4>
        <p>Employees Assigned</p>
    </div>
    <div class="stat-mini">
        <h4><?= $location['is_active'] ? 'Active' : 'Inactive' ?></h4>
        <p>Current Status</p>
    </div>
    <div class="stat-mini">
        <h4><?= date('M d, Y', strtotime($location['created_at'])) ?></h4>
        <p>Date Created</p>
    </div>
</div>

<!-- Info Box -->
<?php if ($employeeCount > 0): ?>
<div class="info-box">
    <i class="fas fa-info-circle fa-lg"></i>
    <strong>Note:</strong> This location is currently assigned to <?= $employeeCount ?> employee(s). Changes to location details will affect all assigned employees.
</div>
<?php endif; ?>

<form action="<?= base_url('settings/locations/update/' . $location['id']) ?>" method="POST" id="locationForm">
    <?= csrf_field() ?>

    <!-- Basic Information -->
    <div class="form-card">
        <h5>
            <i class="fas fa-info-circle"></i>
            Basic Information
        </h5>

        <p class="required-note"><i class="fas fa-asterisk"></i> Required fields</p>

        <div class="row g-3">
            <div class="col-md-6">
                <label class="form-label">Location Name <span class="text-danger">*</span></label>
                <input type="text" class="form-control <?= isset($errors['name']) ? 'is-invalid' : '' ?>"
                       name="name" value="<?= old('name', $location['name']) ?>" required
                       placeholder="e.g., Main Office, Branch A">
                <?php if (isset($errors['name'])): ?>
                    <div class="invalid-feedback"><?= $errors['name'] ?></div>
                <?php endif; ?>
                <small class="helper-text">A descriptive name for the location</small>
            </div>

            <div class="col-md-6">
                <label class="form-label">Location Code <span class="text-danger">*</span></label>
                <input type="text" class="form-control <?= isset($errors['code']) ? 'is-invalid' : '' ?>"
                       name="code" value="<?= old('code', $location['code']) ?>" required
                       placeholder="e.g., HQ, BR01"
                       style="text-transform: uppercase;">
                <?php if (isset($errors['code'])): ?>
                    <div class="invalid-feedback"><?= $errors['code'] ?></div>
                <?php endif; ?>
                <small class="helper-text">Unique code (uppercase, no spaces)</small>
            </div>

            <div class="col-md-12">
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" name="is_active" id="isActive"
                           <?= old('is_active', $location['is_active']) ? 'checked' : '' ?> value="1">
                    <label class="form-check-label" for="isActive">
                        <strong>Active Location</strong>
                        <small class="d-block text-muted">Employees can be assigned to this location</small>
                    </label>
                </div>
            </div>
        </div>
    </div>

    <!-- Address Information -->
    <div class="form-card">
        <h5>
            <i class="fas fa-map-marked-alt"></i>
            Address Information
        </h5>

        <div class="row g-3">
            <div class="col-md-12">
                <label class="form-label">Street Address</label>
                <input type="text" class="form-control <?= isset($errors['address']) ? 'is-invalid' : '' ?>"
                       name="address" value="<?= old('address', $location['address']) ?>"
                       placeholder="e.g., 123 Main Street, Building A">
                <?php if (isset($errors['address'])): ?>
                    <div class="invalid-feedback"><?= $errors['address'] ?></div>
                <?php endif; ?>
            </div>

            <div class="col-md-6">
                <label class="form-label">City</label>
                <input type="text" class="form-control <?= isset($errors['city']) ? 'is-invalid' : '' ?>"
                       name="city" value="<?= old('city', $location['city']) ?>"
                       placeholder="e.g., Manila">
                <?php if (isset($errors['city'])): ?>
                    <div class="invalid-feedback"><?= $errors['city'] ?></div>
                <?php endif; ?>
            </div>

            <div class="col-md-6">
                <label class="form-label">Province/State</label>
                <input type="text" class="form-control <?= isset($errors['province']) ? 'is-invalid' : '' ?>"
                       name="province" value="<?= old('province', $location['province']) ?>"
                       placeholder="e.g., Metro Manila">
                <?php if (isset($errors['province'])): ?>
                    <div class="invalid-feedback"><?= $errors['province'] ?></div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Contact Information -->
    <div class="form-card">
        <h5>
            <i class="fas fa-address-book"></i>
            Contact Information
        </h5>

        <div class="row g-3">
            <div class="col-md-6">
                <label class="form-label">Contact Number</label>
                <input type="text" class="form-control <?= isset($errors['contact_number']) ? 'is-invalid' : '' ?>"
                       name="contact_number" value="<?= old('contact_number', $location['contact_number']) ?>"
                       placeholder="e.g., +63 123 456 7890">
                <?php if (isset($errors['contact_number'])): ?>
                    <div class="invalid-feedback"><?= $errors['contact_number'] ?></div>
                <?php endif; ?>
            </div>

            <div class="col-md-6">
                <label class="form-label">Email Address</label>
                <input type="email" class="form-control <?= isset($errors['email']) ? 'is-invalid' : '' ?>"
                       name="email" value="<?= old('email', $location['email']) ?>"
                       placeholder="e.g., branch@company.com">
                <?php if (isset($errors['email'])): ?>
                    <div class="invalid-feedback"><?= $errors['email'] ?></div>
                <?php endif; ?>
            </div>

            <div class="col-md-12">
                <label class="form-label">Timezone</label>
                <select class="form-select <?= isset($errors['timezone']) ? 'is-invalid' : '' ?>" name="timezone">
                    <option value="">Select Timezone (Optional)</option>
                    <option value="Asia/Manila" <?= old('timezone', $location['timezone']) == 'Asia/Manila' ? 'selected' : '' ?>>Asia/Manila (PHT - UTC+8)</option>
                    <option value="Asia/Singapore" <?= old('timezone', $location['timezone']) == 'Asia/Singapore' ? 'selected' : '' ?>>Asia/Singapore (SGT - UTC+8)</option>
                    <option value="Asia/Tokyo" <?= old('timezone', $location['timezone']) == 'Asia/Tokyo' ? 'selected' : '' ?>>Asia/Tokyo (JST - UTC+9)</option>
                    <option value="Asia/Hong_Kong" <?= old('timezone', $location['timezone']) == 'Asia/Hong_Kong' ? 'selected' : '' ?>>Asia/Hong Kong (HKT - UTC+8)</option>
                    <option value="Asia/Kuala_Lumpur" <?= old('timezone', $location['timezone']) == 'Asia/Kuala_Lumpur' ? 'selected' : '' ?>>Asia/Kuala Lumpur (MYT - UTC+8)</option>
                    <option value="Asia/Jakarta" <?= old('timezone', $location['timezone']) == 'Asia/Jakarta' ? 'selected' : '' ?>>Asia/Jakarta (WIB - UTC+7)</option>
                    <option value="America/New_York" <?= old('timezone', $location['timezone']) == 'America/New_York' ? 'selected' : '' ?>>America/New York (EST - UTC-5)</option>
                    <option value="America/Los_Angeles" <?= old('timezone', $location['timezone']) == 'America/Los_Angeles' ? 'selected' : '' ?>>America/Los Angeles (PST - UTC-8)</option>
                    <option value="Europe/London" <?= old('timezone', $location['timezone']) == 'Europe/London' ? 'selected' : '' ?>>Europe/London (GMT - UTC+0)</option>
                    <option value="UTC" <?= old('timezone', $location['timezone']) == 'UTC' ? 'selected' : '' ?>>UTC (Universal Time)</option>
                </select>
                <?php if (isset($errors['timezone'])): ?>
                    <div class="invalid-feedback"><?= $errors['timezone'] ?></div>
                <?php endif; ?>
                <small class="helper-text">Used for scheduling and time-based operations</small>
            </div>
        </div>
    </div>

    <!-- Geographic Coordinates -->
    <div class="form-card">
        <h5>
            <i class="fas fa-map-pin"></i>
            Geographic Coordinates
        </h5>

        <p class="text-muted mb-3">
            <small>
                <i class="fas fa-info-circle me-1"></i>
                Optional: Add GPS coordinates for mapping and location-based features.
                You can find these on <a href="https://www.google.com/maps" target="_blank">Google Maps</a>.
            </small>
        </p>

        <div class="row g-3">
            <div class="col-md-6">
                <label class="form-label">Latitude</label>
                <input type="text" class="form-control coordinate-input <?= isset($errors['latitude']) ? 'is-invalid' : '' ?>"
                       name="latitude" value="<?= old('latitude', $location['latitude']) ?>"
                       placeholder="e.g., 14.599512">
                <?php if (isset($errors['latitude'])): ?>
                    <div class="invalid-feedback"><?= $errors['latitude'] ?></div>
                <?php endif; ?>
                <small class="helper-text">Decimal degrees format (e.g., 14.599512)</small>
            </div>

            <div class="col-md-6">
                <label class="form-label">Longitude</label>
                <input type="text" class="form-control coordinate-input <?= isset($errors['longitude']) ? 'is-invalid' : '' ?>"
                       name="longitude" value="<?= old('longitude', $location['longitude']) ?>"
                       placeholder="e.g., 120.984222">
                <?php if (isset($errors['longitude'])): ?>
                    <div class="invalid-feedback"><?= $errors['longitude'] ?></div>
                <?php endif; ?>
                <small class="helper-text">Decimal degrees format (e.g., 120.984222)</small>
            </div>

            <?php if ($location['latitude'] && $location['longitude']): ?>
            <div class="col-md-12">
                <div class="map-link-box">
                    <i class="fas fa-map-marked-alt me-2"></i>
                    <a href="https://www.google.com/maps?q=<?= $location['latitude'] ?>,<?= $location['longitude'] ?>"
                       target="_blank">
                        View Current Location on Google Maps
                    </a>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Submit Footer -->
    <div class="sticky-footer">
        <div class="d-flex justify-content-end align-items-center">
            <a href="<?= base_url('settings/locations') ?>" class="btn btn-outline-secondary me-2">
                <i class="fas fa-times me-2"></i>Cancel
            </a>
            <button type="submit" class="btn btn-primary btn-lg">
                <i class="fas fa-save me-2"></i>Update Location
            </button>
        </div>
    </div>
</form>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
    // Force uppercase for code
    document.querySelector('input[name="code"]').addEventListener('input', function(e) {
        e.target.value = e.target.value.toUpperCase();
    });

    // Form validation
    document.getElementById('locationForm').addEventListener('submit', function(e) {
        const latitude = document.querySelector('input[name="latitude"]').value;
        const longitude = document.querySelector('input[name="longitude"]').value;

        // If one coordinate is provided, both must be provided
        if ((latitude && !longitude) || (!latitude && longitude)) {
            e.preventDefault();
            alert('Please provide both latitude and longitude, or leave both empty.');
            return false;
        }

        // Validate coordinate format
        if (latitude && longitude) {
            const latPattern = /^-?([0-9]{1,2}|1[0-7][0-9]|180)(\.[0-9]+)?$/;
            const lonPattern = /^-?([0-9]{1,2}|1[0-7][0-9]|180)(\.[0-9]+)?$/;

            if (!latPattern.test(latitude)) {
                e.preventDefault();
                alert('Invalid latitude format. Please use decimal degrees (e.g., 14.599512)');
                return false;
            }

            if (!lonPattern.test(longitude)) {
                e.preventDefault();
                alert('Invalid longitude format. Please use decimal degrees (e.g., 120.984222)');
                return false;
            }
        }
    });
</script>
<?= $this->endSection() ?>
