<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<style>
    .form-card {
        background: white;
        border-radius: 12px;
        padding: 30px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    }

    .permission-section {
        background: white;
        border-radius: 12px;
        padding: 30px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        margin-top: 20px;
    }

    .permission-module {
        background: #f8f9fa;
        border-radius: 8px;
        padding: 20px;
        margin-bottom: 20px;
        border-left: 4px solid #667eea;
    }

    .permission-module h5 {
        font-weight: 600;
        margin-bottom: 15px;
        color: #333;
        display: flex;
        align-items: center;
        justify-content: space-between;
    }

    .module-icon {
        width: 40px;
        height: 40px;
        border-radius: 8px;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        display: inline-flex;
        align-items: center;
        justify-content: center;
        color: white;
        margin-right: 10px;
    }

    .permission-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
        gap: 12px;
    }

    .permission-item {
        background: white;
        border: 2px solid #e0e0e0;
        border-radius: 8px;
        padding: 12px 15px;
        transition: all 0.3s;
        cursor: pointer;
    }

    .permission-item:hover {
        border-color: #667eea;
        background: #f8f9ff;
    }

    .permission-item.selected {
        border-color: #667eea;
        background: linear-gradient(135deg, rgba(102, 126, 234, 0.1) 0%, rgba(118, 75, 162, 0.1) 100%);
    }

    .permission-item input[type="checkbox"] {
        width: 18px;
        height: 18px;
        margin-right: 10px;
        cursor: pointer;
    }

    .permission-item label {
        cursor: pointer;
        margin: 0;
        display: flex;
        align-items: center;
        font-weight: 500;
    }

    .permission-description {
        font-size: 12px;
        color: #666;
        margin-top: 5px;
        margin-left: 28px;
    }

    .select-all-btn {
        font-size: 13px;
        padding: 4px 12px;
    }

    .permission-count {
        background: #667eea;
        color: white;
        padding: 4px 12px;
        border-radius: 20px;
        font-size: 12px;
        font-weight: 600;
    }

    .sticky-footer {
        position: sticky;
        bottom: 0;
        background: white;
        padding: 20px 30px;
        box-shadow: 0 -2px 8px rgba(0, 0, 0, 0.08);
        border-radius: 12px;
        margin-top: 20px;
    }

    .info-box {
        background: #e3f2fd;
        border-left: 4px solid #2196f3;
        padding: 15px;
        border-radius: 8px;
        margin-bottom: 20px;
    }

    .info-box i {
        color: #2196f3;
        margin-right: 10px;
    }
</style>

<!-- Page Header -->
<div class="row mb-4">
    <div class="col-md-12">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h3 class="mb-2">Create New Role</h3>
                <p class="text-muted mb-0">Define a new user role with specific permissions</p>
            </div>
            <a href="<?= base_url('settings/roles') ?>" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left me-2"></i>Back to Roles
            </a>
        </div>
    </div>
</div>

<!-- Info Box -->
<div class="info-box">
    <i class="fas fa-info-circle fa-lg"></i>
    <strong>Role & Permissions:</strong> Roles define what users can do in the system. Assign permissions to control access to specific features and functionalities.
</div>

<form action="<?= base_url('settings/roles/store') ?>" method="POST" id="roleForm">
    <?= csrf_field() ?>

    <!-- Basic Information -->
    <div class="form-card">
        <h5 class="mb-4">
            <i class="fas fa-info-circle me-2"></i>Basic Information
        </h5>

        <div class="row g-3">
            <div class="col-md-6">
                <label class="form-label">Role Name <span class="text-danger">*</span></label>
                <input type="text" class="form-control <?= isset($errors['name']) ? 'is-invalid' : '' ?>"
                       name="name" value="<?= old('name') ?>" required
                       placeholder="e.g., Manager, Supervisor">
                <?php if (isset($errors['name'])): ?>
                    <div class="invalid-feedback"><?= $errors['name'] ?></div>
                <?php endif; ?>
                <small class="text-muted">A descriptive name for the role</small>
            </div>

            <div class="col-md-6">
                <label class="form-label">Role Slug <span class="text-danger">*</span></label>
                <input type="text" class="form-control <?= isset($errors['slug']) ? 'is-invalid' : '' ?>"
                       name="slug" value="<?= old('slug') ?>" required
                       placeholder="e.g., manager, supervisor">
                <?php if (isset($errors['slug'])): ?>
                    <div class="invalid-feedback"><?= $errors['slug'] ?></div>
                <?php endif; ?>
                <small class="text-muted">Lowercase, no spaces (use hyphens or underscores)</small>
            </div>

            <div class="col-md-12">
                <label class="form-label">Description</label>
                <textarea class="form-control" name="description" rows="3"
                          placeholder="Describe the role and its responsibilities"><?= old('description') ?></textarea>
                <small class="text-muted">Optional description of the role</small>
            </div>

            <div class="col-md-12">
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" name="is_active" id="isActive"
                           <?= old('is_active', '1') ? 'checked' : '' ?> value="1">
                    <label class="form-check-label" for="isActive">
                        <strong>Active Role</strong>
                        <small class="d-block text-muted">Users can be assigned to this role</small>
                    </label>
                </div>
            </div>
        </div>
    </div>

    <!-- Permissions -->
    <div class="permission-section">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h5 class="mb-0">
                <i class="fas fa-shield-alt me-2"></i>Assign Permissions
            </h5>
            <div>
                <span class="permission-count" id="selectedCount">0 selected</span>
                <button type="button" class="btn btn-sm btn-outline-primary ms-2" onclick="selectAllPermissions()">
                    <i class="fas fa-check-double me-1"></i>Select All
                </button>
                <button type="button" class="btn btn-sm btn-outline-secondary ms-1" onclick="deselectAllPermissions()">
                    <i class="fas fa-times me-1"></i>Deselect All
                </button>
            </div>
        </div>

        <?php if (!empty($permissions)): ?>
            <?php foreach ($permissions as $module => $perms): ?>
            <div class="permission-module">
                <h5>
                    <div>
                        <span class="module-icon">
                            <i class="fas fa-<?= getModuleIcon($module) ?>"></i>
                        </span>
                        <?= esc($module) ?>
                    </div>
                    <button type="button" class="btn btn-sm btn-outline-primary select-all-btn"
                            onclick="selectModulePermissions('<?= esc($module) ?>')">
                        <i class="fas fa-check me-1"></i>Select All
                    </button>
                </h5>

                <div class="permission-grid">
                    <?php foreach ($perms as $permission): ?>
                    <div class="permission-item" data-module="<?= esc($module) ?>"
                         onclick="togglePermission(<?= $permission['id'] ?>)">
                        <label>
                            <input type="checkbox" name="permissions[]"
                                   value="<?= $permission['id'] ?>"
                                   id="perm-<?= $permission['id'] ?>"
                                   onchange="updateSelectedCount()">
                            <?= esc($permission['name']) ?>
                        </label>
                        <?php if ($permission['description']): ?>
                        <div class="permission-description">
                            <?= esc($permission['description']) ?>
                        </div>
                        <?php endif; ?>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
            <?php endforeach; ?>
        <?php else: ?>
            <div class="alert alert-warning">
                <i class="fas fa-exclamation-triangle me-2"></i>
                No permissions available. Please contact the system administrator.
            </div>
        <?php endif; ?>
    </div>

    <!-- Submit Footer -->
    <div class="sticky-footer">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <span class="text-muted">
                    <i class="fas fa-shield-alt me-2"></i>
                    <span id="selectedCountFooter">0</span> permissions selected
                </span>
            </div>
            <div>
                <a href="<?= base_url('settings/roles') ?>" class="btn btn-outline-secondary me-2">
                    <i class="fas fa-times me-2"></i>Cancel
                </a>
                <button type="submit" class="btn btn-primary btn-lg">
                    <i class="fas fa-save me-2"></i>Create Role
                </button>
            </div>
        </div>
    </div>
</form>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
    // Auto-generate slug from name
    document.querySelector('input[name="name"]').addEventListener('input', function(e) {
        const slug = e.target.value
            .toLowerCase()
            .replace(/[^a-z0-9]+/g, '-')
            .replace(/^-+|-+$/g, '');
        document.querySelector('input[name="slug"]').value = slug;
    });

    // Toggle permission checkbox when clicking the item
    function togglePermission(permissionId) {
        const checkbox = document.getElementById('perm-' + permissionId);
        checkbox.checked = !checkbox.checked;
        updatePermissionItemStyle(permissionId);
        updateSelectedCount();
    }

    // Update permission item style based on checkbox state
    function updatePermissionItemStyle(permissionId) {
        const checkbox = document.getElementById('perm-' + permissionId);
        const item = checkbox.closest('.permission-item');
        if (checkbox.checked) {
            item.classList.add('selected');
        } else {
            item.classList.remove('selected');
        }
    }

    // Prevent label click from double-toggling
    document.querySelectorAll('.permission-item label').forEach(label => {
        label.addEventListener('click', function(e) {
            e.stopPropagation();
        });
    });

    // Update selected count
    function updateSelectedCount() {
        const count = document.querySelectorAll('input[name="permissions[]"]:checked').length;
        document.getElementById('selectedCount').textContent = count + ' selected';
        document.getElementById('selectedCountFooter').textContent = count;

        // Update all permission item styles
        document.querySelectorAll('input[name="permissions[]"]').forEach(checkbox => {
            const item = checkbox.closest('.permission-item');
            if (checkbox.checked) {
                item.classList.add('selected');
            } else {
                item.classList.remove('selected');
            }
        });
    }

    // Select all permissions
    function selectAllPermissions() {
        document.querySelectorAll('input[name="permissions[]"]').forEach(checkbox => {
            checkbox.checked = true;
        });
        updateSelectedCount();
    }

    // Deselect all permissions
    function deselectAllPermissions() {
        document.querySelectorAll('input[name="permissions[]"]').forEach(checkbox => {
            checkbox.checked = false;
        });
        updateSelectedCount();
    }

    // Select all permissions in a module
    function selectModulePermissions(module) {
        document.querySelectorAll(`.permission-item[data-module="${module}"] input[type="checkbox"]`).forEach(checkbox => {
            checkbox.checked = true;
        });
        updateSelectedCount();
    }

    // Initialize on page load
    document.addEventListener('DOMContentLoaded', function() {
        updateSelectedCount();
    });

    // Form validation
    document.getElementById('roleForm').addEventListener('submit', function(e) {
        const selectedCount = document.querySelectorAll('input[name="permissions[]"]:checked').length;
        if (selectedCount === 0) {
            e.preventDefault();
            alert('Please select at least one permission for this role.');
            return false;
        }
    });
</script>
<?= $this->endSection() ?>

<?php
// Helper function for module icons
function getModuleIcon($module) {
    $icons = [
        'Dashboard' => 'tachometer-alt',
        'Employees' => 'users',
        'Attendance' => 'clock',
        'Leave' => 'calendar-alt',
        'Reports' => 'chart-bar',
        'Settings' => 'cog',
        'Users' => 'user-shield',
        'Roles' => 'user-tag',
        'System' => 'cogs',
        'Audit' => 'history',
    ];
    return $icons[$module] ?? 'shield-alt';
}
?>
