<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<style>
    .settings-container {
        display: flex;
        gap: 20px;
    }

    .settings-sidebar {
        width: 250px;
        background: white;
        border-radius: 12px;
        padding: 20px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        height: fit-content;
        position: sticky;
        top: 100px;
    }

    .settings-sidebar h6 {
        font-weight: 600;
        margin-bottom: 15px;
        color: #333;
        font-size: 13px;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .nav-link {
        padding: 10px 15px;
        color: #666;
        text-decoration: none;
        display: flex;
        align-items: center;
        border-radius: 8px;
        margin-bottom: 5px;
        transition: all 0.3s;
    }

    .nav-link:hover {
        background: #f8f9fa;
        color: #667eea;
    }

    .nav-link.active {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
    }

    .nav-link i {
        margin-right: 10px;
        width: 20px;
        text-align: center;
    }

    .settings-content {
        flex: 1;
    }

    .settings-section {
        background: white;
        border-radius: 12px;
        padding: 30px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        margin-bottom: 20px;
        display: none;
    }

    .settings-section.active {
        display: block;
    }

    .settings-section h4 {
        font-weight: 600;
        margin-bottom: 10px;
        color: #333;
    }

    .settings-section .section-description {
        color: #666;
        margin-bottom: 25px;
        font-size: 14px;
    }

    .setting-item {
        padding: 20px;
        border-bottom: 1px solid #f0f0f0;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .setting-item:last-child {
        border-bottom: none;
    }

    .setting-info {
        flex: 1;
        margin-right: 20px;
    }

    .setting-label {
        font-weight: 600;
        color: #333;
        margin-bottom: 5px;
        display: block;
    }

    .setting-description {
        color: #999;
        font-size: 13px;
    }

    .setting-control {
        min-width: 300px;
    }

    .setting-control input[type="text"],
    .setting-control input[type="number"],
    .setting-control input[type="time"],
    .setting-control select {
        width: 100%;
    }

    .toggle-switch {
        position: relative;
        display: inline-block;
        width: 50px;
        height: 24px;
    }

    .toggle-switch input {
        opacity: 0;
        width: 0;
        height: 0;
    }

    .toggle-slider {
        position: absolute;
        cursor: pointer;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-color: #ccc;
        transition: .4s;
        border-radius: 24px;
    }

    .toggle-slider:before {
        position: absolute;
        content: "";
        height: 18px;
        width: 18px;
        left: 3px;
        bottom: 3px;
        background-color: white;
        transition: .4s;
        border-radius: 50%;
    }

    input:checked + .toggle-slider {
        background-color: #667eea;
    }

    input:checked + .toggle-slider:before {
        transform: translateX(26px);
    }

    .info-box {
        background: #e3f2fd;
        border-left: 4px solid #2196f3;
        padding: 15px;
        border-radius: 8px;
        margin-bottom: 20px;
    }

    .info-box i {
        color: #2196f3;
        margin-right: 10px;
    }

    .sticky-footer {
        position: sticky;
        bottom: 0;
        background: white;
        padding: 20px 30px;
        box-shadow: 0 -2px 8px rgba(0, 0, 0, 0.08);
        border-radius: 12px;
        margin-top: 20px;
        z-index: 100;
    }

    .action-buttons {
        display: flex;
        gap: 10px;
        margin-bottom: 20px;
    }

    @media (max-width: 992px) {
        .settings-container {
            flex-direction: column;
        }

        .settings-sidebar {
            width: 100%;
            position: relative;
            top: 0;
        }

        .setting-control {
            min-width: 200px;
        }
    }
</style>

<!-- Page Header -->
<div class="row mb-4">
    <div class="col-md-12">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h3 class="mb-2">System Settings</h3>
                <p class="text-muted mb-0">Configure system-wide settings and preferences</p>
            </div>
            <div class="d-flex gap-2">
                <button class="btn btn-outline-secondary" onclick="exportSettings()">
                    <i class="fas fa-download me-2"></i>Export Settings
                </button>
                <button class="btn btn-outline-warning" onclick="clearCache()">
                    <i class="fas fa-sync me-2"></i>Clear Cache
                </button>
            </div>
        </div>
    </div>
</div>

<?php if (!$canEdit): ?>
<div class="info-box">
    <i class="fas fa-lock fa-lg"></i>
    <strong>Read-Only Mode:</strong> You have permission to view settings but not to edit them. Contact your administrator to request edit access.
</div>
<?php endif; ?>

<form action="<?= base_url('settings/system/update') ?>" method="POST" id="settingsForm">
    <?= csrf_field() ?>

    <div class="settings-container">
        <!-- Sidebar Navigation -->
        <div class="settings-sidebar">
            <h6>Settings Categories</h6>
            <nav>
                <a href="#general" class="nav-link active" onclick="showSection('general', event)">
                    <i class="fas fa-cog"></i>
                    General
                </a>
                <a href="#attendance" class="nav-link" onclick="showSection('attendance', event)">
                    <i class="fas fa-clock"></i>
                    Attendance
                </a>
                <a href="#leave" class="nav-link" onclick="showSection('leave', event)">
                    <i class="fas fa-calendar-alt"></i>
                    Leave
                </a>
                <a href="#email" class="nav-link" onclick="showSection('email', event)">
                    <i class="fas fa-envelope"></i>
                    Email
                </a>
                <a href="#reports" class="nav-link" onclick="showSection('reports', event)">
                    <i class="fas fa-chart-bar"></i>
                    Reports
                </a>
                <a href="#sync" class="nav-link" onclick="showSection('sync', event)">
                    <i class="fas fa-sync-alt"></i>
                    Synchronization
                </a>
            </nav>
        </div>

        <!-- Settings Content -->
        <div class="settings-content">
            <!-- General Settings -->
            <div id="section-general" class="settings-section active">
                <h4><i class="fas fa-cog me-2"></i>General Settings</h4>
                <p class="section-description">Basic system configuration and preferences</p>

                <?php if (isset($settings['general'])): ?>
                    <?php foreach ($settings['general'] as $setting): ?>
                    <div class="setting-item">
                        <div class="setting-info">
                            <span class="setting-label"><?= esc(ucwords(str_replace('_', ' ', $setting['key']))) ?></span>
                            <span class="setting-description"><?= esc($setting['description']) ?></span>
                        </div>
                        <div class="setting-control">
                            <?= renderSettingControl($setting, $canEdit) ?>
                        </div>
                    </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <p class="text-muted">No general settings configured.</p>
                <?php endif; ?>
            </div>

            <!-- Attendance Settings -->
            <div id="section-attendance" class="settings-section">
                <h4><i class="fas fa-clock me-2"></i>Attendance Settings</h4>
                <p class="section-description">Configure attendance tracking and work schedule settings</p>

                <?php if (isset($settings['attendance'])): ?>
                    <?php foreach ($settings['attendance'] as $setting): ?>
                    <div class="setting-item">
                        <div class="setting-info">
                            <span class="setting-label"><?= esc(ucwords(str_replace('_', ' ', $setting['key']))) ?></span>
                            <span class="setting-description"><?= esc($setting['description']) ?></span>
                        </div>
                        <div class="setting-control">
                            <?= renderSettingControl($setting, $canEdit) ?>
                        </div>
                    </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <p class="text-muted">No attendance settings configured.</p>
                <?php endif; ?>
            </div>

            <!-- Leave Settings -->
            <div id="section-leave" class="settings-section">
                <h4><i class="fas fa-calendar-alt me-2"></i>Leave Settings</h4>
                <p class="section-description">Configure leave management policies and rules</p>

                <?php if (isset($settings['leave'])): ?>
                    <?php foreach ($settings['leave'] as $setting): ?>
                    <div class="setting-item">
                        <div class="setting-info">
                            <span class="setting-label"><?= esc(ucwords(str_replace('_', ' ', $setting['key']))) ?></span>
                            <span class="setting-description"><?= esc($setting['description']) ?></span>
                        </div>
                        <div class="setting-control">
                            <?= renderSettingControl($setting, $canEdit) ?>
                        </div>
                    </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <p class="text-muted">No leave settings configured.</p>
                <?php endif; ?>
            </div>

            <!-- Email Settings -->
            <div id="section-email" class="settings-section">
                <h4><i class="fas fa-envelope me-2"></i>Email Settings</h4>
                <p class="section-description">Configure SMTP and email notification settings</p>

                <div class="action-buttons">
                    <button type="button" class="btn btn-sm btn-outline-primary" onclick="testEmail()">
                        <i class="fas fa-paper-plane me-1"></i>Send Test Email
                    </button>
                </div>

                <?php if (isset($settings['email'])): ?>
                    <?php foreach ($settings['email'] as $setting): ?>
                    <div class="setting-item">
                        <div class="setting-info">
                            <span class="setting-label"><?= esc(ucwords(str_replace('_', ' ', $setting['key']))) ?></span>
                            <span class="setting-description"><?= esc($setting['description']) ?></span>
                        </div>
                        <div class="setting-control">
                            <?= renderSettingControl($setting, $canEdit) ?>
                        </div>
                    </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <p class="text-muted">No email settings configured.</p>
                <?php endif; ?>
            </div>

            <!-- Report Settings -->
            <div id="section-reports" class="settings-section">
                <h4><i class="fas fa-chart-bar me-2"></i>Report Settings</h4>
                <p class="section-description">Configure report generation and formatting options</p>

                <?php if (isset($settings['reports'])): ?>
                    <?php foreach ($settings['reports'] as $setting): ?>
                    <div class="setting-item">
                        <div class="setting-info">
                            <span class="setting-label"><?= esc(ucwords(str_replace('_', ' ', $setting['key']))) ?></span>
                            <span class="setting-description"><?= esc($setting['description']) ?></span>
                        </div>
                        <div class="setting-control">
                            <?= renderSettingControl($setting, $canEdit) ?>
                        </div>
                    </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <p class="text-muted">No report settings configured.</p>
                <?php endif; ?>
            </div>

            <!-- Synchronization Settings -->
            <div id="section-sync" class="settings-section">
                <h4><i class="fas fa-sync-alt me-2"></i>Synchronization Settings</h4>
                <p class="section-description">Configure offline attendance synchronization and data sync from mobile devices</p>

                <div class="info-box mb-4">
                    <i class="fas fa-info-circle"></i>
                    <strong>About Synchronization:</strong> These settings control how the system handles attendance data synced from mobile devices operating in offline mode. The mobile app can collect attendance records offline and sync them when connectivity is restored.
                </div>

                <?php if (isset($settings['sync']) && !empty($settings['sync'])): ?>
                    <?php foreach ($settings['sync'] as $setting): ?>
                    <div class="setting-item">
                        <div class="setting-info">
                            <span class="setting-label"><?= esc(ucwords(str_replace('_', ' ', $setting['key']))) ?></span>
                            <span class="setting-description"><?= esc($setting['description']) ?></span>
                        </div>
                        <div class="setting-control">
                            <?= renderSettingControl($setting, $canEdit) ?>
                        </div>
                    </div>
                    <?php endforeach; ?>

                    <!-- Sync Statistics -->
                    <div class="mt-4 p-3 border rounded">
                        <h6 class="mb-3"><i class="fas fa-chart-line me-2"></i>Sync Statistics</h6>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="text-center p-2">
                                    <h3 class="text-primary mb-1" id="sync-total-records">-</h3>
                                    <small class="text-muted">Total Synced (30 days)</small>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="text-center p-2">
                                    <h3 class="text-success mb-1" id="sync-success-rate">-</h3>
                                    <small class="text-muted">Success Rate</small>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="text-center p-2">
                                    <h3 class="text-warning mb-1" id="sync-pending-records">-</h3>
                                    <small class="text-muted">Pending Review</small>
                                </div>
                            </div>
                        </div>
                        <div class="text-center mt-3">
                            <button type="button" class="btn btn-sm btn-outline-primary" onclick="loadSyncStatistics()">
                                <i class="fas fa-refresh me-2"></i>Refresh Statistics
                            </button>
                        </div>
                    </div>
                <?php else: ?>
                    <p class="text-muted">No synchronization settings configured. Please run the database migration to add sync settings.</p>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Submit Footer -->
    <?php if ($canEdit): ?>
    <div class="sticky-footer">
        <div class="d-flex justify-content-between align-items-center">
            <span class="text-muted">
                <i class="fas fa-info-circle me-2"></i>
                Changes will be applied immediately after saving
            </span>
            <div>
                <button type="button" class="btn btn-outline-secondary me-2" onclick="resetForm()">
                    <i class="fas fa-undo me-2"></i>Reset Changes
                </button>
                <button type="submit" class="btn btn-primary btn-lg">
                    <i class="fas fa-save me-2"></i>Save All Settings
                </button>
            </div>
        </div>
    </div>
    <?php endif; ?>
</form>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
    // Show section
    function showSection(section, event) {
        if (event) {
            event.preventDefault();
        }

        // Hide all sections
        document.querySelectorAll('.settings-section').forEach(sec => {
            sec.classList.remove('active');
        });

        // Remove active class from all nav links
        document.querySelectorAll('.nav-link').forEach(link => {
            link.classList.remove('active');
        });

        // Show selected section
        document.getElementById('section-' + section).classList.add('active');

        // Add active class to clicked nav link
        event.target.closest('.nav-link').classList.add('active');

        // Update URL hash
        window.location.hash = section;
    }

    // Load section from URL hash on page load
    document.addEventListener('DOMContentLoaded', function() {
        const hash = window.location.hash.substring(1);
        if (hash) {
            const link = document.querySelector(`a[href="#${hash}"]`);
            if (link) {
                link.click();
            }
        }
    });

    // Reset form
    function resetForm() {
        if (confirm('Are you sure you want to reset all changes? This will reload the page.')) {
            location.reload();
        }
    }

    // Test email
    function testEmail() {
        const email = prompt('Enter your email address to receive a test email:');
        if (!email) return;

        fetch('<?= base_url('settings/system/testEmail') ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: JSON.stringify({ test_email: email })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert(data.message);
            } else {
                alert('Error: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Failed to send test email');
        });
    }

    // Export settings
    function exportSettings() {
        window.location.href = '<?= base_url('settings/system/export') ?>';
    }

    // Clear cache
    function clearCache() {
        if (!confirm('Are you sure you want to clear the system cache?')) {
            return;
        }

        fetch('<?= base_url('settings/system/clearCache') ?>', {
            method: 'POST',
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            alert(data.message);
            if (data.success) {
                location.reload();
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Failed to clear cache');
        });
    }

    // Form submission confirmation
    document.getElementById('settingsForm').addEventListener('submit', function(e) {
        if (!confirm('Save all settings changes?')) {
            e.preventDefault();
        }
    });

    // Employee number preview
    function updateEmployeeNumberPreview() {
        const prefix = document.querySelector('input[name="employee_number_prefix"]')?.value || 'EMP';
        const padding = document.querySelector('input[name="employee_number_padding"]')?.value || '4';
        const startNumber = document.querySelector('input[name="employee_number_start"]')?.value || '1';

        // Create preview element if it doesn't exist
        let previewDiv = document.getElementById('employee_number_preview');
        if (!previewDiv) {
            const prefixInput = document.querySelector('input[name="employee_number_prefix"]');
            if (prefixInput) {
                const settingItem = prefixInput.closest('.setting-item');
                previewDiv = document.createElement('div');
                previewDiv.id = 'employee_number_preview';
                previewDiv.className = 'alert alert-info mt-3';
                previewDiv.style.marginBottom = '0';
                settingItem.parentElement.insertBefore(previewDiv, settingItem.nextSibling);
            }
        }

        if (previewDiv) {
            const paddedNumber = startNumber.toString().padStart(parseInt(padding), '0');
            const preview = prefix + paddedNumber;
            previewDiv.innerHTML = `
                <i class="fas fa-eye me-2"></i>
                <strong>Preview:</strong> Next employee number will be: <code class="bg-white px-2 py-1">${preview}</code>
            `;
        }
    }

    // Add event listeners for employee number settings
    document.addEventListener('DOMContentLoaded', function() {
        const employeeFields = [
            'employee_number_prefix',
            'employee_number_padding',
            'employee_number_start'
        ];

        employeeFields.forEach(fieldName => {
            const field = document.querySelector(`input[name="${fieldName}"]`);
            if (field) {
                field.addEventListener('input', updateEmployeeNumberPreview);
                field.addEventListener('change', updateEmployeeNumberPreview);
            }
        });

        // Initial preview
        updateEmployeeNumberPreview();
    });

    // Load sync statistics
    function loadSyncStatistics() {
        const totalEl = document.getElementById('sync-total-records');
        const successRateEl = document.getElementById('sync-success-rate');
        const pendingEl = document.getElementById('sync-pending-records');

        // Show loading state
        totalEl.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';
        successRateEl.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';
        pendingEl.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';

        fetch('<?= base_url('api/sync/statistics') ?>', {
            method: 'GET',
            headers: {
                'Content-Type': 'application/json',
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                totalEl.textContent = data.data.total_records || '0';
                successRateEl.textContent = (data.data.success_rate || '0') + '%';
                pendingEl.textContent = data.data.pending_records || '0';
            } else {
                throw new Error(data.message || 'Failed to load statistics');
            }
        })
        .catch(error => {
            console.error('Error loading sync statistics:', error);
            totalEl.textContent = 'Error';
            successRateEl.textContent = 'Error';
            pendingEl.textContent = 'Error';
        });
    }

    // Load sync statistics on page load if sync section exists
    document.addEventListener('DOMContentLoaded', function() {
        if (document.getElementById('sync-total-records')) {
            loadSyncStatistics();
        }
    });
</script>
<?= $this->endSection() ?>

<?php
// Helper function to render setting controls
function renderSettingControl($setting, $canEdit) {
    $disabled = !$canEdit ? 'disabled' : '';
    $value = esc($setting['value']);
    $name = esc($setting['key']);

    switch ($setting['type']) {
        case 'boolean':
            $checked = $value ? 'checked' : '';
            return "
                <label class='toggle-switch'>
                    <input type='checkbox' name='{$name}' value='1' {$checked} {$disabled}>
                    <span class='toggle-slider'></span>
                </label>
            ";

        case 'number':
            return "<input type='number' class='form-control' name='{$name}' value='{$value}' {$disabled}>";

        case 'time':
            return "<input type='time' class='form-control' name='{$name}' value='{$value}' {$disabled}>";

        case 'select':
            // Handle specific select fields
            if ($name === 'sync_conflict_resolution') {
                $options = [
                    'server_wins' => 'Server Wins (Server data takes priority)',
                    'client_wins' => 'Client Wins (Mobile data takes priority)',
                    'manual' => 'Manual Review (Requires admin review)'
                ];
                $html = "<select class='form-select' name='{$name}' {$disabled}>";
                foreach ($options as $optValue => $optLabel) {
                    $selected = ($value == $optValue) ? 'selected' : '';
                    $html .= "<option value='{$optValue}' {$selected}>{$optLabel}</option>";
                }
                $html .= "</select>";
                return $html;
            }
            return "<select class='form-select' name='{$name}' {$disabled}><option>{$value}</option></select>";

        default:
            return "<input type='text' class='form-control' name='{$name}' value='{$value}' {$disabled}>";
    }
}
?>
