<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<!-- Header with Actions -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-user me-2"></i><?= esc($pageTitle) ?></h2>
    <div>
        <a href="<?= base_url('settings/users') ?>" class="btn btn-outline-secondary me-2">
            <i class="fas fa-arrow-left"></i> Back to List
        </a>

        <?php if (has_permission('edit-user')): ?>
        <a href="<?= base_url('settings/users/edit/' . $user['id']) ?>" class="btn btn-primary">
            <i class="fas fa-edit"></i> Edit User
        </a>
        <?php endif; ?>
    </div>
</div>

<div class="row">
    <!-- User Profile Card -->
    <div class="col-md-4 mb-4">
        <div class="table-card text-center">
            <?php if (!empty($user['profile_photo'])): ?>
            <img src="<?= base_url('uploads/users/' . $user['profile_photo']) ?>"
                 alt="<?= esc($user['first_name']) ?>"
                 class="rounded-circle mb-3"
                 style="width: 150px; height: 150px; object-fit: cover;">
            <?php else: ?>
            <div class="rounded-circle bg-primary text-white d-inline-flex align-items-center justify-content-center mb-3"
                 style="width: 150px; height: 150px; font-size: 60px;">
                <?= strtoupper(substr($user['first_name'], 0, 1) . substr($user['last_name'], 0, 1)) ?>
            </div>
            <?php endif; ?>

            <h4><?= esc($user['first_name'] . ' ' . $user['last_name']) ?></h4>
            <p class="text-muted mb-1"><i class="fas fa-at"></i> <?= esc($user['username']) ?></p>
            <p class="text-muted mb-3"><?= esc($user['role_name'] ?? 'N/A') ?></p>

            <div class="mb-3">
                <span class="badge bg-<?= $user['is_active'] ? 'success' : 'danger' ?> fs-6">
                    <?= $user['is_active'] ? 'Active' : 'Inactive' ?>
                </span>
            </div>

            <?php if (!empty($user['employee_number'])): ?>
            <div class="p-3 bg-light rounded">
                <h6 class="text-muted mb-2">Linked to Employee</h6>
                <p class="mb-0"><strong><?= esc($user['emp_first_name'] . ' ' . $user['emp_last_name']) ?></strong></p>
                <p class="mb-0"><code><?= esc($user['employee_number']) ?></code></p>
                <a href="<?= base_url('employees/view/' . $user['employee_id']) ?>" class="btn btn-sm btn-outline-primary mt-2">
                    <i class="fas fa-external-link-alt me-1"></i>View Employee
                </a>
            </div>
            <?php endif; ?>
        </div>

        <!-- Quick Stats Card -->
        <div class="table-card mt-3">
            <h5 class="mb-3"><i class="fas fa-chart-bar me-2"></i>Quick Stats</h5>
            <div class="d-flex justify-content-between mb-2">
                <span>Status</span>
                <strong><?= $user['is_active'] ? 'Active' : 'Inactive' ?></strong>
            </div>
            <div class="d-flex justify-content-between mb-2">
                <span>Role</span>
                <strong><?= esc($user['role_name'] ?? 'N/A') ?></strong>
            </div>
            <?php if (!empty($user['location_name'])): ?>
            <div class="d-flex justify-content-between mb-2">
                <span>Location</span>
                <strong><?= esc($user['location_name']) ?></strong>
            </div>
            <?php endif; ?>
            <div class="d-flex justify-content-between mb-2">
                <span>Permissions</span>
                <strong><?= count($permissions) ?></strong>
            </div>
        </div>
    </div>

    <!-- User Details -->
    <div class="col-md-8">
        <!-- Contact Information -->
        <div class="table-card mb-4">
            <h5 class="mb-3"><i class="fas fa-address-card me-2"></i>Contact Information</h5>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="text-muted small">Username</label>
                    <p class="mb-0"><code><?= esc($user['username']) ?></code></p>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="text-muted small">Email Address</label>
                    <p class="mb-0">
                        <?php if (!empty($user['email'])): ?>
                        <a href="mailto:<?= esc($user['email']) ?>"><?= esc($user['email']) ?></a>
                        <?php else: ?>
                        -
                        <?php endif; ?>
                    </p>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="text-muted small">Phone Number</label>
                    <p class="mb-0"><?= esc($user['phone'] ?? '-') ?></p>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="text-muted small">Last Login</label>
                    <p class="mb-0">
                        <?= !empty($user['last_login']) ? date('M d, Y h:i A', strtotime($user['last_login'])) : 'Never' ?>
                    </p>
                </div>
            </div>
        </div>

        <!-- Role & Permissions -->
        <div class="table-card mb-4">
            <h5 class="mb-3"><i class="fas fa-shield-alt me-2"></i>Role & Permissions</h5>
            <div class="row mb-3">
                <div class="col-md-12">
                    <label class="text-muted small">Role</label>
                    <p class="mb-0">
                        <span class="badge bg-primary fs-6"><?= esc($user['role_name'] ?? 'No Role') ?></span>
                        <?php if (!empty($user['role_slug'])): ?>
                            <code class="ms-2"><?= esc($user['role_slug']) ?></code>
                        <?php endif; ?>
                    </p>
                </div>
            </div>

            <?php if (!empty($permissions)): ?>
            <div class="row">
                <div class="col-md-12">
                    <label class="text-muted small mb-2">Assigned Permissions (<?= count($permissions) ?>)</label>
                    <div class="row">
                        <?php
                        // Group permissions by module
                        $groupedPerms = [];
                        foreach ($permissions as $perm) {
                            $groupedPerms[$perm['module']][] = $perm;
                        }
                        ?>
                        <?php foreach ($groupedPerms as $module => $perms): ?>
                        <div class="col-md-6 mb-3">
                            <h6 class="text-primary mb-2"><i class="fas fa-folder me-1"></i><?= esc($module) ?></h6>
                            <ul class="list-unstyled ms-3">
                                <?php foreach ($perms as $perm): ?>
                                <li class="mb-1">
                                    <i class="fas fa-check-circle text-success me-2"></i>
                                    <small><?= esc($perm['name']) ?></small>
                                </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
            <?php else: ?>
            <div class="alert alert-warning mb-0">
                <i class="fas fa-exclamation-triangle me-2"></i>No permissions assigned to this user's role
            </div>
            <?php endif; ?>
        </div>

        <!-- Account Information -->
        <div class="table-card mb-4">
            <h5 class="mb-3"><i class="fas fa-info-circle me-2"></i>Account Information</h5>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="text-muted small">Account Created</label>
                    <p class="mb-0"><?= date('M d, Y h:i A', strtotime($user['created_at'])) ?></p>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="text-muted small">Last Updated</label>
                    <p class="mb-0"><?= date('M d, Y h:i A', strtotime($user['updated_at'])) ?></p>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="text-muted small">Account Status</label>
                    <p class="mb-0">
                        <span class="badge bg-<?= $user['is_active'] ? 'success' : 'danger' ?>">
                            <?= $user['is_active'] ? 'Active' : 'Inactive' ?>
                        </span>
                    </p>
                </div>
            </div>
        </div>

        <!-- Recent Activity -->
        <?php if (!empty($recentActivity)): ?>
        <div class="table-card">
            <h5 class="mb-3"><i class="fas fa-history me-2"></i>Recent Activity</h5>
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Action</th>
                            <th>Module</th>
                            <th>Description</th>
                            <th>Date/Time</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($recentActivity as $activity): ?>
                        <tr>
                            <td>
                                <span class="badge bg-<?=
                                    $activity['action'] == 'create' ? 'success' :
                                    ($activity['action'] == 'update' ? 'info' :
                                    ($activity['action'] == 'delete' ? 'danger' : 'secondary'))
                                ?>">
                                    <?= esc(ucfirst($activity['action'])) ?>
                                </span>
                            </td>
                            <td><?= esc($activity['module'] ?? 'N/A') ?></td>
                            <td><?= esc($activity['description'] ?? 'N/A') ?></td>
                            <td>
                                <small><?= date('M d, Y h:i A', strtotime($activity['created_at'])) ?></small>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>

<?= $this->endSection() ?>
